/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.features.custom.detailedblocks.DetailedBlocks;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.safebreak.SafeBreak;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MineInSphere
extends BlockCommand {
    @Override
    public void run(final Player p, final @NotNull Block block, SCommandToExec sCommandToExec) {
        final List<String> args = sCommandToExec.getOtherArgs();
        final ActionInfo aInfo = sCommandToExec.getActionInfo();
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (aInfo.isEventFromCustomBreakCommand()) {
                    return;
                }
                try {
                    int radius = Integer.parseInt((String)args.get(0));
                    int radiusSquared = radius * radius;
                    Location origin = block.getLocation();
                    boolean drop = true;
                    if (args.size() >= 2) {
                        drop = Boolean.parseBoolean((String)args.get(1));
                    }
                    boolean createBBEvent = true;
                    if (args.size() >= 3) {
                        createBBEvent = Boolean.parseBoolean((String)args.get(2));
                    }
                    ArrayList<Material> blackList = new ArrayList<Material>();
                    blackList.add(Material.BEDROCK);
                    blackList.add(Material.AIR);
                    boolean isv18plus = SCore.is1v18Plus();
                    if (radius < 10) {
                        for (int y = -radius; y < radius + 1; ++y) {
                            for (int x = -radius; x < radius + 1; ++x) {
                                for (int z = -radius; z < radius + 1; ++z) {
                                    Location toBreakLoc = new Location(block.getWorld(), (double)(block.getX() + x), (double)(block.getY() + y), (double)(block.getZ() + z));
                                    if (toBreakLoc.distanceSquared(origin) > (double)radiusSquared || (isv18plus ? block.getY() + y < -64 : block.getY() + y < 0)) continue;
                                    Block toBreak = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                                    DetailedBlocks whiteList = aInfo.getDetailedBlocks();
                                    if (whiteList != null && !whiteList.isValid(toBreak, Optional.empty(), null, new StringPlaceholder()) || blackList.contains(toBreak.getType())) continue;
                                    UUID pUUID = null;
                                    if (p != null) {
                                        pUUID = p.getUniqueId();
                                    }
                                    SafeBreak.breakBlockWithEvent(toBreak, pUUID, aInfo.getSlot(), drop, createBBEvent, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE);
                                }
                            }
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        SCore.schedulerHook.runTask(runnable3, 1L);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("MINEINSPHERE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "MINEINSPHERE {radius} {ActiveDrop true or false} {create blockBreakEvent true or false}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

