/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.entity;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.commands.runnable.RunCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.entity.EntityCommandManager;
import com.ssomar.score.commands.runnable.entity.EntitySCommand;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityRunCommand
extends RunCommand {
    private static final long serialVersionUID = 1L;
    private UUID launcherUUID;
    private UUID entityUUID;
    private boolean silenceOutput;

    public EntityRunCommand(String brutCommand, int delay, ActionInfo aInfo) {
        super(brutCommand, delay, aInfo);
    }

    public EntityRunCommand(String brutCommand, long runTime, ActionInfo aInfo) {
        super(brutCommand, runTime, aInfo);
    }

    @Override
    public void pickupInfo() {
        ActionInfo aInfo = this.getaInfo();
        this.launcherUUID = aInfo.getLauncherUUID();
        this.entityUUID = aInfo.getEntityUUID();
        this.silenceOutput = aInfo.isSilenceOutput();
    }

    @Override
    public void runGetManager() {
        this.runCommand(EntityCommandManager.getInstance());
    }

    @Override
    public void runCommand(SCommandToExec sCommandToExec) {
        EntitySCommand pCommand = (EntitySCommand)((Object)sCommandToExec.getSCommand());
        this.pickupInfo();
        Player launcher = null;
        if (this.launcherUUID != null) {
            launcher = Bukkit.getPlayer((UUID)this.launcherUUID);
        }
        Entity receiver = null;
        if (SCore.is1v11Less()) {
            block0: for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!entity.getUniqueId().equals(this.entityUUID)) continue;
                    receiver = entity;
                    continue block0;
                }
            }
        } else {
            receiver = Bukkit.getEntity((UUID)this.entityUUID);
        }
        if (receiver != null) {
            sCommandToExec.setActionInfo(this.getaInfo());
            pCommand.run(launcher, receiver, sCommandToExec);
        }
    }

    @Override
    public void insideDelayedCommand() {
        this.runCommand(EntityCommandManager.getInstance());
        CommandsHandler.getInstance().removeDelayedCommand(this.getUuid(), this.entityUUID);
    }

    @Override
    public void executeRunnable(Runnable runnable) {
        Entity receiver = null;
        if (SCore.is1v11Less()) {
            block0: for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!entity.getUniqueId().equals(this.entityUUID)) continue;
                    receiver = entity;
                    continue block0;
                }
            }
        } else {
            receiver = Bukkit.getEntity((UUID)this.entityUUID);
        }
        if (receiver != null) {
            SCore.schedulerHook.runEntityTaskAsap(runnable, null, receiver);
        }
    }

    @Generated
    public UUID getLauncherUUID() {
        return this.launcherUUID;
    }

    @Generated
    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    @Generated
    public boolean isSilenceOutput() {
        return this.silenceOutput;
    }

    @Generated
    public void setLauncherUUID(UUID launcherUUID) {
        this.launcherUUID = launcherUUID;
    }

    @Generated
    public void setEntityUUID(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    @Generated
    public void setSilenceOutput(boolean silenceOutput) {
        this.silenceOutput = silenceOutput;
    }
}

