/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.logging.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SecurityOPQuery {
    private static final String TABLE_SECURITYOP = "securityop";
    private static final String TABLE_SECURITYOP_NAME = "SecurityOP";
    private static final String COL_PLAYER = "player";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS securityop (player TEXT NOT NULL);";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("SecurityOPQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6SecurityOP &7if not exists...");
            stmt.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table SecurityOP in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertPlayerOP(Connection conn, List<Player> players) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("SecurityOPQuery insertPlayerOP");
        }
        String sql = "INSERT INTO securityop (player) VALUES(?)";
        PreparedStatement pstmt = null;
        int i = 0;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Player player : players) {
                pstmt.setString(1, player.getUniqueId().toString());
                pstmt.addBatch();
                if (++i % 15 != 0 && i != players.size()) continue;
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static void deletePlayerOP(final Connection conn, final Player p, boolean async) {
        if (async) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SecurityOPQuery.deletePlayerOP(conn, p);
                }
            };
            SCore.schedulerHook.runAsyncTask(runnable, 0L);
        } else {
            SecurityOPQuery.deletePlayerOP(conn, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deletePlayerOP(Connection conn, Player p) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("SecurityOPQuery deletePlayerOP");
        }
        String sql = "DELETE FROM securityop where player=?";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, p.getUniqueId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean selectIfSecurityOPcontains(Connection conn, Player p) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("SecurityOPQuery selectIfSecurityOPcontains");
        }
        String sql = "SELECT player FROM securityop where player=?";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, p.getUniqueId().toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UUID> loadUsersOp(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("SecurityOPQuery loadUsersOp");
        }
        String sql = "SELECT * FROM securityop";
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        ArrayList<UUID> list = new ArrayList<UUID>();
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String player = rs.getString(COL_PLAYER);
                try {
                    list.add(UUID.fromString(player));
                }
                catch (Exception e) {
                    try {
                        list.add(Bukkit.getServer().getOfflinePlayer(player).getUniqueId());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (SQLException e) {
            System.out.println("[ExecutableItems] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

