/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.events;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForBlockArgs;
import com.ssomar.score.features.custom.ItemSpawnerFeature;
import com.ssomar.score.usedapi.Dependency;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FixSpawnerPlaceListener
implements Listener {
    private static final Boolean DEBUG = false;

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlaceEvent(BlockPlaceEvent e) {
        ExecutableItem ei;
        ItemSpawnerFeature isf;
        ExecutableItemObject eio;
        SsomarDev.testMsg("FixSpawnerPlaceEvent.onBlockPlaceEvent()", DEBUG);
        Block block = e.getBlock();
        ItemStack is = e.getItemInHand();
        if (!is.hasItemMeta()) {
            return;
        }
        if (SCore.is1v11Less()) {
            return;
        }
        if (Dependency.EXECUTABLE_ITEMS.isEnabled() && (eio = new ExecutableItemObject(is)).isValid() && (isf = (ei = eio.getConfig()).getSpawner()) != null && !isf.getPotentialSpawns().getCurrentValues().isEmpty()) {
            isf.applyOnBlockData(FeatureForBlockArgs.create(block.getBlockData(), block.getState(), block.getType()));
            SsomarDev.testMsg(">> Its a spawner ! add spawner info", true);
        }
        ItemMeta im = is.getItemMeta();
        if (!(SCore.is1v20v5Plus() || im.hasLocalizedName() && im.getLocalizedName().equals("FROM_EXECUTABLEITEM"))) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)SCore.plugin, "SPAWNER_SILK_SCORE");
        if (!im.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            return;
        }
        Material spawer = SCore.is1v12Less() ? Material.valueOf((String)"MOB_SPAWNER") : Material.SPAWNER;
        SsomarDev.testMsg("item hand: " + is.getType() + " equals ? " + is.getType().equals((Object)spawer), DEBUG);
        if (is.getType().equals((Object)spawer)) {
            SsomarDev.testMsg(">> Its a spawner ! ", DEBUG);
            CreatureSpawner cs = (CreatureSpawner)block.getState();
            BlockStateMeta meta = (BlockStateMeta)is.getItemMeta();
            CreatureSpawner csm = (CreatureSpawner)meta.getBlockState();
            SsomarDev.testMsg(">> type of the spawner placed ! " + csm.getSpawnedType(), DEBUG);
            cs.setSpawnedType(csm.getSpawnedType());
            cs.update();
        }
    }
}

