/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features;

import com.google.common.base.Charsets;
import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.SavingVerbosityLevel;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.utils.scheduler.RunnableManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public abstract class FeatureAbstract<FINAL_VALUE_CLASS, FEATURE_CLASS>
implements FeatureInterface<FINAL_VALUE_CLASS, FEATURE_CLASS>,
Serializable {
    private FeatureSettingsInterface featureSettings;
    private transient FeatureParentInterface parent;
    private boolean isPremium;
    private boolean saveLaunched;

    public FeatureAbstract(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        this.parent = parent;
        if (parent == null && this instanceof FeatureParentInterface) {
            this.parent = (FeatureParentInterface)((Object)this);
        }
        this.featureSettings = featureSettings;
        this.isPremium = parent != null ? parent.isPremium() : true;
    }

    @Override
    public FeatureSettingsInterface getFeatureSettings() {
        return this.featureSettings;
    }

    @Override
    public String getName() {
        return this.featureSettings.getName();
    }

    @Override
    public String getEditorName() {
        return this.featureSettings.getEditorName();
    }

    public String[] getEditorDescription() {
        return this.featureSettings.getEditorDescription();
    }

    public Material getEditorMaterial() {
        return this.featureSettings.getEditorMaterial();
    }

    @Override
    public boolean isRequirePremium() {
        return this.featureSettings == null || this.featureSettings.isRequirePremium();
    }

    public static void space(Player p) {
        p.sendMessage("");
    }

    public <M> FeatureReturnCheckPremium<M> checkPremium(String featureTypeName, M value, Optional<M> defaultValue, boolean isPremiumLoading) {
        if (this.isRequirePremium() && !isPremiumLoading) {
            if (defaultValue.isPresent()) {
                if (!defaultValue.get().equals(value)) {
                    return new FeatureReturnCheckPremium<M>("&cERROR, Couldn't load the " + featureTypeName + " value of " + this.getName() + " from config, value: " + value + " &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium feature ! (reset to default: " + defaultValue.get() + ")", defaultValue.get());
                }
            } else {
                return new FeatureReturnCheckPremium<Object>("&cERROR, Couldn't load the " + featureTypeName + " value of " + this.getName() + " from config, value: " + value + " &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium feature !", null);
            }
        }
        return new FeatureReturnCheckPremium();
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.equals(this.getEditorName());
    }

    @Override
    public void initAndUpdateItemParentEditor(GUI gui, int slot) {
        this.initItemParentEditor(gui, slot).updateItemParentEditor(gui);
    }

    public void save(boolean saveInstantly) {
        long delay = 2400L;
        if (saveInstantly) {
            delay = 0L;
        }
        if (!this.saveLaunched || saveInstantly) {
            this.saveLaunched = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ConfigurationSection config = FeatureAbstract.this.parent.getConfigurationSection();
                    FeatureAbstract.this.save(config);
                    while (config.getParent() != null) {
                        config = config.getParent();
                    }
                    FeatureAbstract.this.writeInFile(config);
                    FeatureAbstract.this.saveLaunched = false;
                    RunnableManager.getInstance().removeTask(this);
                }
            };
            if (delay == 0L) {
                runnable.run();
            } else {
                RunnableManager.getInstance().addTask(runnable);
                SCore.schedulerHook.runTask(runnable, delay);
            }
        }
    }

    public void save() {
        this.save(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInFile(ConfigurationSection config) {
        block5: {
            try {
                File file = this.parent.getFile();
                if (!file.exists()) break block5;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
                    writer.write(((FileConfiguration)config).saveToString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public abstract FeatureInterface clone(FeatureParentInterface var1);

    public FeatureParentInterface getParent() {
        if (this instanceof FeatureParentInterface && this.parent == this) {
            return (FeatureParentInterface)((Object)this);
        }
        return this.parent;
    }

    public <B> Optional<B> getParent(B clazz) {
        FeatureParentInterface parent = this.getParent();
        while (parent != null && parent instanceof FeatureInterface && ((FeatureAbstract)((Object)parent)).getParent() != parent) {
            Class<?> classs = clazz.getClass();
            if (parent.getClass() == classs) {
                return Optional.of(parent);
            }
            parent = ((FeatureAbstract)((Object)parent)).getParent();
            parent.reload();
        }
        return Optional.empty();
    }

    public boolean isSavingOnlyIfDiffDefault() {
        return (GeneralConfig.getInstance().isVerbosityMinimal() || this.getFeatureSettings().getSavingVerbosityLevel() == SavingVerbosityLevel.SAVE_ONLY_WHEN_DIFFERENT_DEFAULT) && !GeneralConfig.getInstance().isVerbosityMaximal();
    }

    @Generated
    public boolean isPremium() {
        return this.isPremium;
    }

    @Generated
    public boolean isSaveLaunched() {
        return this.saveLaunched;
    }

    @Generated
    public void setParent(FeatureParentInterface parent) {
        this.parent = parent;
    }

    @Generated
    public void setPremium(boolean isPremium) {
        this.isPremium = isPremium;
    }
}

