/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.chiseledbookshelf;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.list.ListIntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ChiseledBookshelfFeatures
extends FeatureWithHisOwnEditor<ChiseledBookshelfFeatures, ChiseledBookshelfFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private ListIntegerFeature occupiedSlots;

    public ChiseledBookshelfFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.chiseledBookshelfFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.occupiedSlots = new ListIntegerFeature((FeatureParentInterface)this, new ArrayList<Integer>(), FeatureSettingsSCore.occupiedSlots, Optional.empty());
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection containerFeaturesSection = config.getConfigurationSection(this.getName());
            error.addAll(this.occupiedSlots.load(plugin, containerFeaturesSection, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection furnaceFeaturesSection = config.createSection(this.getName());
        this.occupiedSlots.save(furnaceFeaturesSection);
    }

    @Override
    public ChiseledBookshelfFeatures getValue() {
        return this;
    }

    @Override
    public ChiseledBookshelfFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Occupied slots: &e" + this.occupiedSlots.getCurrentValues().size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ChiseledBookshelfFeatures clone(FeatureParentInterface newParent) {
        ChiseledBookshelfFeatures eF = new ChiseledBookshelfFeatures(newParent);
        eF.occupiedSlots = this.occupiedSlots.clone(eF);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.occupiedSlots);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ChiseledBookshelfFeatures)) continue;
            ChiseledBookshelfFeatures eF = (ChiseledBookshelfFeatures)feature;
            eF.setOccupiedSlots(this.occupiedSlots);
            break;
        }
    }

    public boolean canBeApplied(BlockData blockData) {
        return SCore.is1v20Plus() && blockData instanceof ChiseledBookshelf;
    }

    public void applyChiseledBookshelfFeatures(final Block block) {
        if (this.canBeApplied(block.getBlockData())) {
            final ChiseledBookshelf chiseledBookshelf = (ChiseledBookshelf)block.getBlockData();
            Iterator iterator = this.occupiedSlots.getValue().iterator();
            while (iterator.hasNext()) {
                Integer i = (Integer)iterator.next();
                chiseledBookshelf.setSlotOccupied(i.intValue(), true);
                SsomarDev.testMsg("Slot " + i + " is occupied", true);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block.getWorld().getPlayers().forEach(p -> p.sendBlockChange(block.getLocation(), (BlockData)chiseledBookshelf));
                }
            };
            SCore.schedulerHook.runLocationTask(runnable, block.getLocation(), 3L);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public ListIntegerFeature getOccupiedSlots() {
        return this.occupiedSlots;
    }

    @Generated
    public void setOccupiedSlots(ListIntegerFeature occupiedSlots) {
        this.occupiedSlots = occupiedSlots;
    }
}

