/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.cooldowns;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Cooldown {
    private static final boolean DEBUG = false;
    private String id;
    @Nullable
    private UUID entityUUID;
    private int cooldown;
    private boolean isInTick;
    private long time;
    private boolean global;
    private boolean isNull;
    private boolean pauseWhenOffline;
    private PlaceholderConditionGroupFeature pausePlaceholdersConditions;
    private boolean isPaused;

    public Cooldown(SPlugin sPlugin, SObject sO, SActivator sAct, UUID entityUUID, int cooldown, boolean isInTick, long time, boolean global) {
        this.id = sPlugin.getShortName() + ":" + sO.getId() + ":" + sAct.getId();
        this.entityUUID = entityUUID;
        this.cooldown = cooldown;
        this.isInTick = isInTick;
        this.time = time;
        this.global = global;
        this.isNull = false;
        this.pauseWhenOffline = false;
        this.pausePlaceholdersConditions = new PlaceholderConditionGroupFeature(null, FeatureSettingsSCore.pausePlaceholdersConditions);
        this.isPaused = false;
    }

    public Cooldown(SPlugin sPlugin, String id, UUID entityUUID, int cooldown, boolean isInTick, long time, boolean global) {
        this.id = id;
        this.entityUUID = entityUUID;
        this.cooldown = cooldown;
        this.isInTick = isInTick;
        this.time = time;
        this.global = global;
        this.isNull = false;
        this.pauseWhenOffline = false;
        this.pausePlaceholdersConditions = new PlaceholderConditionGroupFeature(null, FeatureSettingsSCore.pausePlaceholdersConditions);
        this.isPaused = false;
    }

    public Cooldown(String id, UUID entityUUID, int cooldown, boolean isInTick, long time, boolean global) {
        this.id = id;
        this.entityUUID = entityUUID;
        this.cooldown = cooldown;
        this.isInTick = isInTick;
        this.time = time;
        this.global = global;
        this.isNull = false;
        this.pauseWhenOffline = false;
        this.pausePlaceholdersConditions = new PlaceholderConditionGroupFeature(null, FeatureSettingsSCore.pausePlaceholdersConditions);
        this.isPaused = false;
    }

    public Cooldown setPauseFeatures(boolean pauseWhenOffline, PlaceholderConditionGroupFeature pausePlaceholdersConditions) {
        this.pauseWhenOffline = pauseWhenOffline;
        this.pausePlaceholdersConditions = pausePlaceholdersConditions;
        return this;
    }

    public int getTimeLeftFlatValue() {
        if (this.isPaused) {
            return this.cooldown;
        }
        long current = System.currentTimeMillis();
        long delay = current - this.getTime();
        int div = 1000;
        if (this.isInTick()) {
            div = 50;
        }
        int delayInt = (int)(delay / (long)div);
        SsomarDev.testMsg("delayInt: " + delayInt, false);
        return this.getCooldown() - delayInt;
    }

    public double getTimeLeft() {
        int timeLeft = this.getTimeLeftFlatValue();
        SsomarDev.testMsg("timeLeft: " + timeLeft, false);
        double result = timeLeft;
        SsomarDev.testMsg("pre  result: " + result / 20.0, false);
        if (this.isInTick()) {
            result /= 20.0;
        }
        SsomarDev.testMsg("Cooldown: " + result, false);
        return result;
    }

    public Cooldown updatePlayerDisconnect() {
        if (!this.global && this.pauseWhenOffline && !this.isPaused) {
            this.cooldown = this.getTimeLeftFlatValue();
            this.time = System.currentTimeMillis();
            this.isPaused = true;
        }
        return this;
    }

    public Cooldown updatePlayerReconnect() {
        if (!this.global && this.pauseWhenOffline && this.isPaused) {
            this.time = System.currentTimeMillis();
            this.isPaused = false;
        }
        return this;
    }

    public Cooldown updatePausePlaceholdersConditions() {
        Player player;
        SsomarDev.testMsg("updatePausePlaceholdersConditions not global ?" + !this.global + " +++ not empty?" + !this.pausePlaceholdersConditions.getPlaceholdersConditions().isEmpty(), false);
        if (!this.global && !this.pausePlaceholdersConditions.getPlaceholdersConditions().isEmpty() && (player = Bukkit.getPlayer((UUID)this.entityUUID)) != null) {
            boolean result = this.pausePlaceholdersConditions.verifConditions(player, new ArrayList<String>());
            SsomarDev.testMsg("updatePausePlaceholdersConditions RESULT >> " + result + " PAUSED ?" + this.isPaused, false);
            if (!this.isPaused && result) {
                SsomarDev.testMsg("updatePausePlaceholdersConditions PAUSED", false);
                this.cooldown = this.getTimeLeftFlatValue();
                this.time = System.currentTimeMillis();
                this.isPaused = true;
            } else if (this.isPaused && !result) {
                SsomarDev.testMsg("updatePausePlaceholdersConditions UNPAUSED", false);
                this.time = System.currentTimeMillis();
                this.isPaused = false;
            }
        }
        return this;
    }

    public String toString() {
        return "id:" + this.id + " >>>> entityUUID:" + this.entityUUID + " >>>> coolodwn:" + this.cooldown + " >>>> isInTick:" + this.isInTick + " >>>> time:" + this.time + " isNull ? " + this.isNull + " >>>> timeLeft:" + this.getTimeLeft() + " >>>> global ?" + this.global + " >>>> pauseWhenOffline:" + this.pauseWhenOffline + " >>>> pausePlaceholdersCdts size:" + this.pausePlaceholdersConditions.getPlaceholdersConditions().size() + " >>>> paused ?" + this.isPaused;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Nullable
    @Generated
    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }

    @Generated
    public boolean isInTick() {
        return this.isInTick;
    }

    @Generated
    public long getTime() {
        return this.time;
    }

    @Generated
    public boolean isGlobal() {
        return this.global;
    }

    @Generated
    public boolean isNull() {
        return this.isNull;
    }

    @Generated
    public boolean isPauseWhenOffline() {
        return this.pauseWhenOffline;
    }

    @Generated
    public PlaceholderConditionGroupFeature getPausePlaceholdersConditions() {
        return this.pausePlaceholdersConditions;
    }

    @Generated
    public boolean isPaused() {
        return this.isPaused;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEntityUUID(@Nullable UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    @Generated
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setInTick(boolean isInTick) {
        this.isInTick = isInTick;
    }

    @Generated
    public void setTime(long time) {
        this.time = time;
    }

    @Generated
    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Generated
    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    @Generated
    public void setPauseWhenOffline(boolean pauseWhenOffline) {
        this.pauseWhenOffline = pauseWhenOffline;
    }

    @Generated
    public void setPausePlaceholdersConditions(PlaceholderConditionGroupFeature pausePlaceholdersConditions) {
        this.pausePlaceholdersConditions = pausePlaceholdersConditions;
    }

    @Generated
    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }
}

