/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.headfeatures;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.headfeatures.HeadBuilder118;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.HeadDB;
import com.ssomar.score.usedapi.HeadDatabase;
import com.ssomar.score.utils.FixedMaterial;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class HeadFeatures
extends FeatureWithHisOwnEditor<HeadFeatures, HeadFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private UncoloredStringFeature headValue;
    private UncoloredStringFeature headDBID;

    public HeadFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.headFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.headValue = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.headValue, false);
        this.headDBID = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.headDBID, false);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.headValue.load(plugin, config, isPremiumLoading));
        errors.addAll(this.headDBID.load(plugin, config, isPremiumLoading));
        return errors;
    }

    private ItemStack getHeadOrSub(Material or) {
        if (((Optional)this.headDBID.getValue()).isPresent()) {
            ItemStack item;
            if (SCore.hasHeadDatabase) {
                item = HeadDatabase.getInstance().getHead((String)((Optional)this.headDBID.getValue()).get());
                if (item != null) {
                    return item;
                }
                SCore.plugin.getLogger().severe(" Error when creating the Head: " + (String)((Optional)this.headDBID.getValue()).get() + " invalid head database id ! (" + (String)((Optional)this.headDBID.getValue()).get() + ")");
                SCore.plugin.getLogger().severe(" If you use HeadDB, be sure that the plugin has finish to fetch all the custom head (generally it takes 20-30 seconds after the start of the server) !");
            }
            if (SCore.hasHeadDB) {
                try {
                    item = HeadDB.getHead(Integer.valueOf((String)((Optional)this.headDBID.getValue()).get()));
                    if (item != null) {
                        return item;
                    }
                    SCore.plugin.getLogger().severe(" Error when creating the Head: " + (String)((Optional)this.headDBID.getValue()).get() + " invalid head database id ! (" + (String)((Optional)this.headDBID.getValue()).get() + ")");
                    SCore.plugin.getLogger().severe(" If you use HeadDD, be sure that the plugin has finish to fetch all the custom head (generally it takes 20-30 seconds after the start of the server) !");
                }
                catch (Exception ignored) {
                    SCore.plugin.getLogger().severe(" Error when creating the Head: " + (String)((Optional)this.headDBID.getValue()).get() + " invalid head database id ! (" + (String)((Optional)this.headDBID.getValue()).get() + ")");
                    SCore.plugin.getLogger().severe(" If you use HeadDB, be sure that the plugin has finish to fetch all the custom head (generally it takes 20-30 seconds after the start of the server) !");
                }
            }
        } else if (((Optional)this.headValue.getValue()).isPresent() && !SCore.is1v12Less()) {
            ItemStack newHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta itemMeta = (SkullMeta)newHead.getItemMeta();
            if (SCore.is1v18Plus()) {
                try {
                    newHead = HeadBuilder118.getHead(HeadBuilder118.getUrlFromBase64((String)((Optional)this.headValue.getValue()).get()).toString());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            GameProfile profile = this.getGameProfile((String)((Optional)this.headValue.getValue()).get());
            Field profileField = null;
            try {
                profileField = itemMeta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(itemMeta, profile);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            newHead.setItemMeta((ItemMeta)itemMeta);
            return newHead;
        }
        return new ItemStack(or);
    }

    public ItemStack getHeadOr(Material or) {
        ItemStack item = this.getHeadOrSub(or);
        if (item.getType() == or || ((Optional)this.headDBID.getValue()).isPresent()) {
            return item;
        }
        Inventory inv = Bukkit.createInventory(null, (int)18);
        inv.addItem(new ItemStack[]{item});
        for (ItemStack it : inv.getContents()) {
            if (it == null) continue;
            return it;
        }
        return item;
    }

    public GameProfile getGameProfile(String input) {
        GameProfile profile = new GameProfile(UUID.fromString("b33183ad-e9c0-4d48-8eea-f8c9358d3568"), "test");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", input));
        return profile;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.headValue.save(config);
        this.headDBID.save(config);
    }

    @Override
    public HeadFeatures getValue() {
        return this;
    }

    @Override
    public HeadFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = SCore.is1v12Less() ? "&7Head value: &c&lNot for 1.12 or lower" : (((Optional)this.headValue.getValue()).isPresent() ? "&7Head value: &a&l\u2714" : "&7Head value: &c&l\u2718");
        finalDescription[finalDescription.length - 1] = ((Optional)this.headDBID.getValue()).isPresent() ? "&7Head DB ID: &a&l\u2714" : "&7Head DB ID: &c&l\u2718";
        gui.createItem(this.getHeadOr(FixedMaterial.getHead()), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public HeadFeatures clone(FeatureParentInterface newParent) {
        HeadFeatures dropFeatures = new HeadFeatures(newParent);
        dropFeatures.setHeadValue(this.headValue.clone(dropFeatures));
        dropFeatures.setHeadDBID(this.headDBID.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        if (!SCore.is1v12Less()) {
            features.add(this.headValue);
        }
        features.add(this.headDBID);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof HeadFeatures)) continue;
            HeadFeatures hiders = (HeadFeatures)feature;
            hiders.setHeadValue(this.headValue);
            hiders.setHeadDBID(this.headDBID);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof SkullMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        ItemMeta meta = args.getMeta();
        SkullMeta skullMeta = (SkullMeta)meta;
        boolean headAlreadySet = false;
        if (((Optional)this.headDBID.getValue()).isPresent()) {
            SkullMeta headMeta;
            ItemStack item;
            if (SCore.hasHeadDatabase) {
                item = HeadDatabase.getInstance().getHead((String)((Optional)this.headDBID.getValue()).get());
                if (item != null) {
                    headMeta = (SkullMeta)item.getItemMeta();
                    if (SCore.is1v19Plus()) {
                        if (headMeta != null && headMeta.getOwnerProfile() != null) {
                            skullMeta.setOwnerProfile(headMeta.getOwnerProfile());
                            headAlreadySet = true;
                        }
                    } else {
                        this.headValue.setValue(Optional.of(HeadDatabase.getInstance().getBase64((String)((Optional)this.headDBID.getValue()).get())));
                    }
                } else {
                    SCore.plugin.getLogger().severe(" Error when creating the Head: " + (String)((Optional)this.headDBID.getValue()).get() + " invalid head database id ! (" + (String)((Optional)this.headDBID.getValue()).get() + ")");
                    SCore.plugin.getLogger().severe(" If you use HeadDB, be sure that the plugin has finish to fetch all the custom head (generally it takes 20-30 seconds after the start of the server) !");
                }
            }
            if (SCore.hasHeadDB) {
                try {
                    item = HeadDB.getHead(Integer.valueOf((String)((Optional)this.headDBID.getValue()).get()));
                    if (item != null) {
                        headMeta = (SkullMeta)item.getItemMeta();
                        if (SCore.is1v19Plus()) {
                            if (headMeta != null && headMeta.getOwnerProfile() != null) {
                                skullMeta.setOwnerProfile(headMeta.getOwnerProfile());
                                headAlreadySet = true;
                            }
                        } else {
                            this.headValue.setValue(Optional.of(HeadDB.getBase64(Integer.valueOf((String)((Optional)this.headDBID.getValue()).get()))));
                        }
                    } else {
                        SCore.plugin.getLogger().severe(" Error when creating the Head: " + (String)((Optional)this.headDBID.getValue()).get() + " invalid head database id ! (" + (String)((Optional)this.headDBID.getValue()).get() + ")");
                        SCore.plugin.getLogger().severe(" If you use HeadDD, be sure that the plugin has finish to fetch all the custom head (generally it takes 20-30 seconds after the start of the server) !");
                    }
                }
                catch (Exception ignored) {
                    SCore.plugin.getLogger().severe(" Error when creating the Head: " + (String)((Optional)this.headDBID.getValue()).get() + " invalid head database id ! (" + (String)((Optional)this.headDBID.getValue()).get() + ")");
                    SCore.plugin.getLogger().severe(" If you use HeadDB, be sure that the plugin has finish to fetch all the custom head (generally it takes 20-30 seconds after the start of the server) !");
                }
            }
        }
        if (!headAlreadySet && ((Optional)this.headValue.getValue()).isPresent() && !SCore.is1v12Less()) {
            if (SCore.is1v18Plus()) {
                try {
                    HeadBuilder118.modifyMeta(skullMeta, HeadBuilder118.getUrlFromBase64((String)((Optional)this.headValue.getValue()).get()).toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                GameProfile profile = this.getGameProfile((String)((Optional)this.headValue.getValue()).get());
                Field profileField = null;
                try {
                    profileField = meta.getClass().getDeclaredField("profile");
                }
                catch (NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                profileField.setAccessible(true);
                try {
                    profileField.set(meta, profile);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        if (!SCore.is1v12Less()) {
            SkullMeta meta = (SkullMeta)args.getMeta();
            if (SCore.is1v18Plus()) {
                if (meta.getOwnerProfile() != null) {
                    String url = meta.getOwnerProfile().getTextures().getSkin().toString();
                    this.headValue.setValue(Optional.of(HeadBuilder118.getBase64FromUrl(url)));
                }
            } else {
                SkullMeta itemMeta = meta;
                Field profileField = null;
                try {
                    profileField = itemMeta.getClass().getDeclaredField("profile");
                }
                catch (NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                profileField.setAccessible(true);
                try {
                    GameProfile profile = (GameProfile)profileField.get(itemMeta);
                    Iterator iterator = profile.getProperties().get((Object)"textures").iterator();
                    if (iterator.hasNext()) {
                        Property p = (Property)iterator.next();
                        this.getHeadValue().setValue(Optional.of(p.getValue()));
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodError throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.HEAD;
    }

    @Generated
    public UncoloredStringFeature getHeadValue() {
        return this.headValue;
    }

    @Generated
    public UncoloredStringFeature getHeadDBID() {
        return this.headDBID;
    }

    @Generated
    public void setHeadValue(UncoloredStringFeature headValue) {
        this.headValue = headValue;
    }

    @Generated
    public void setHeadDBID(UncoloredStringFeature headDBID) {
        this.headDBID = headDBID;
    }
}

