/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class DoubleNBTTag
extends NBTTag {
    private double valueDouble;
    private boolean isValueDouble;

    public DoubleNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public DoubleNBTTag(String key, double valueDouble) {
        super(key);
        this.valueDouble = valueDouble;
        this.isValueDouble = true;
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtItem.getDouble(this.getKey()).doubleValue() != this.getValueDouble()) {
            nbtItem.setDouble(this.getKey(), Double.valueOf(this.getValueDouble()));
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtCompound.getDouble(this.getKey()).doubleValue() != this.getValueDouble()) {
            nbtCompound.setDouble(this.getKey(), Double.valueOf(this.getValueDouble()));
            return true;
        }
        return false;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"DOUBLE");
        configurationSection.set("nbt." + index + ".value", (Object)this.getValueDouble());
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.valueDouble = configurationSection.getDouble("value", 0.0);
    }

    public String toString() {
        return "DOUBLE::" + this.getKey() + "::" + this.getValueDouble();
    }

    @Generated
    public double getValueDouble() {
        return this.valueDouble;
    }
}

