/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.menu;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.IGUI;
import com.ssomar.score.utils.FixedMaterial;
import com.ssomar.score.utils.item.MakeItemGlow;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public abstract class GUI
implements IGUI {
    public static String CLICK_HERE_TO_CHANGE;
    public static String CLICK_TO_REMOVE;
    public static String SHIFT_CLICK_TO_REMOVE;
    public static String SHIFT_LEFT_CLICK_TO_REMOVE;
    public static String PREMIUM;
    public static String TITLE_COLOR;
    public static String PAGE;
    public static String NEXT_PAGE;
    public static String PREVIOUS_PAGE;
    public static String NEW;
    public static String EXIT;
    public static String BACK;
    public static String SAVE;
    public static String REMOVE;
    public static String RESET;
    public static String CHANGE_LANGUAGE;
    public static String CREATION_ID;
    public static Material NEXT_PAGE_MAT;
    public static Material PREVIOUS_PAGE_MAT;
    public static Material WRITABLE_BOOK;
    public static Material CLOCK;
    public static Material ENCHANTING_TABLE;
    public static Material HEAD;
    public static Material GRINDSTONE;
    public static Material COMPARATOR;
    public static Material RED;
    public static Material ORANGE;
    public static Material GREEN;
    public static Material YELLOW;
    public static Material PURPLE;
    public static Material BLUE;
    public static Material LIGHTNING_ROD;
    private Map<String, String> subSettings;
    private Inventory inv;
    private int size;
    private static final boolean test = false;
    private FeatureSettingsInterface settings;

    public GUI(FeatureSettingsInterface settings, int size) {
        this.settings = settings;
        this.initInventory("&l" + settings.getEditorName() + " Editor", size);
        this.subSettings = new HashMap<String, String>();
    }

    public GUI(String name, int size) {
        this.initInventory(name, size);
        this.subSettings = new HashMap<String, String>();
    }

    public void initInventory(String name, int size) {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)StringConverter.coloredString(name));
        this.size = size;
        for (int j = 0; j < size; ++j) {
            this.createBackGroundItem(j);
        }
        if (WRITABLE_BOOK == null) {
            GUI.init();
        }
    }

    public void fullReloadAndReopen(Player player) {
        if (this.settings == null) {
            return;
        }
        this.initInventory("&l" + this.settings.getEditorName() + " Editor", this.size);
        this.update();
        this.openGUISync(player);
    }

    public GUI(Inventory inv) {
        this.inv = inv;
        if (WRITABLE_BOOK == null) {
            GUI.init();
        }
        this.subSettings = new HashMap<String, String>();
    }

    public static void init() {
        WRITABLE_BOOK = FixedMaterial.getMaterial(Arrays.asList("WRITABLE_BOOK", "BOOK_AND_QUILL"));
        CLOCK = FixedMaterial.getMaterial(Arrays.asList("CLOCK", "WATCH"));
        ENCHANTING_TABLE = FixedMaterial.getMaterial(Arrays.asList("ENCHANTING_TABLE", "ENCHANTMENT_TABLE"));
        HEAD = FixedMaterial.getMaterial(Arrays.asList("PLAYER_HEAD", "SKULL_ITEM"));
        COMPARATOR = FixedMaterial.getMaterial(Arrays.asList("COMPARATOR", "REDSTONE_COMPARATOR"));
        NEXT_PAGE_MAT = FixedMaterial.getMaterial(Arrays.asList("PURPLE_STAINED_GLASS_PANE", "ARROW"));
        PREVIOUS_PAGE_MAT = FixedMaterial.getMaterial(Arrays.asList("PURPLE_STAINED_GLASS_PANE", "ARROW"));
        RED = FixedMaterial.getMaterial(Arrays.asList("RED_STAINED_GLASS_PANE", "REDSTONE_BLOCK"));
        ORANGE = FixedMaterial.getMaterial(Arrays.asList("ORANGE_STAINED_GLASS_PANE", "BARRIER"));
        GREEN = FixedMaterial.getMaterial(Arrays.asList("LIME_STAINED_GLASS_PANE", "EMERALD"));
        YELLOW = FixedMaterial.getMaterial(Arrays.asList("YELLOW_STAINED_GLASS_PANE", "HOPPER"));
        PURPLE = FixedMaterial.getMaterial(Arrays.asList("MAGENTA_STAINED_GLASS_PANE", "HOPPER"));
        BLUE = FixedMaterial.getMaterial(Arrays.asList("BLUE_STAINED_GLASS_PANE", "ANVIL"));
        GRINDSTONE = FixedMaterial.getMaterial(Arrays.asList("GRINDSTONE", "ANVIL"));
        LIGHTNING_ROD = FixedMaterial.getMaterial(Arrays.asList("LIGHTNING_ROD", "TRIPWIRE_HOOK"));
        CREATION_ID = TM.g(Text.EDITOR_CREATION_ID_NAME);
        CLICK_HERE_TO_CHANGE = TM.g(Text.EDITOR_EDIT_DESCRIPTION);
        CLICK_TO_REMOVE = TM.g(Text.EDITOR_DELETE_NORMAL_DESCRIPTION);
        SHIFT_CLICK_TO_REMOVE = TM.g(Text.EDITOR_DELETE_SHIFT_DESCRIPTION);
        SHIFT_LEFT_CLICK_TO_REMOVE = TM.g(Text.EDITOR_DELETE_SHIFT_LEFT_DESCRIPTION);
        PREMIUM = TM.g(Text.EDITOR_PREMIUM_DESCRIPTION);
        TITLE_COLOR = TM.g(Text.EDITOR_TITLE_COLOR);
        PAGE = TM.g(Text.EDITOR_PAGE_NAME);
        NEXT_PAGE = TM.g(Text.EDITOR_PAGE_NEXT_NAME);
        PREVIOUS_PAGE = TM.g(Text.EDITOR_PAGE_PREVIOUS_NAME);
        NEW = TM.g(Text.EDITOR_NEW_NAME);
        EXIT = TM.g(Text.EDITOR_EXIT_NAME);
        BACK = TM.g(Text.EDITOR_BACK_NAME);
        SAVE = TM.g(Text.EDITOR_SAVE_NAME);
        REMOVE = TM.g(Text.EDITOR_DELETE_NAME);
        RESET = TM.g(Text.EDITOR_RESET_NAME);
        CHANGE_LANGUAGE = "&6&l\ud83d\udd6e &e&lChange Language";
    }

    public void load() {
    }

    public void update() {
        this.clearAndSetBackground();
        this.load();
    }

    public static void setIdentifier(@NotNull ItemStack item, String identifier) {
        ItemMeta meta = item.getItemMeta();
        identifier = StringConverter.coloredString(identifier);
        if (SCore.is1v12Less()) {
            meta.setDisplayName(identifier);
        } else {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(NamespacedKey.fromString((String)"gui-identifier"), PersistentDataType.STRING, (Object)identifier);
        }
        item.setItemMeta(meta);
    }

    public static String getIdentifier(@NotNull ItemStack item) {
        if (SCore.is1v12Less()) {
            return item.getItemMeta().getDisplayName();
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        return (String)container.get(NamespacedKey.fromString((String)"gui-identifier"), PersistentDataType.STRING);
    }

    public static boolean isIdentifier(@NotNull ItemStack item, String identifier) {
        return StringConverter.decoloredString(GUI.getIdentifier(item)).equals(StringConverter.decoloredString(identifier));
    }

    public static boolean hasIdentifier(@NotNull ItemStack item) {
        if (SCore.is1v12Less()) {
            return item.getItemMeta().hasDisplayName();
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        return container.has(NamespacedKey.fromString((String)"gui-identifier"), PersistentDataType.STRING);
    }

    public void createItem(Material material, int amount, int invSlot, String displayName, boolean glow, boolean haveEnchant, String ... loreString) {
        ItemStack item = new ItemStack(material, amount);
        GUI.setIdentifier(item, displayName);
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (glow || haveEnchant) {
            meta = MakeItemGlow.makeGlow(meta);
        }
        ItemFlag additionnalFlag = SCore.is1v20v5Plus() ? ItemFlag.HIDE_ADDITIONAL_TOOLTIP : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
        meta.addItemFlags(new ItemFlag[]{additionnalFlag});
        meta.setDisplayName(StringConverter.coloredString(displayName));
        for (String s : loreString) {
            lore.add(StringConverter.coloredString(s));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.inv.setItem(invSlot, item);
    }

    public void addItem(Material material, int amount, String displayName, boolean glow, boolean haveEnchant, String ... loreString) {
        ItemStack item;
        int i = 0;
        ListIterator listIterator = this.inv.iterator();
        while (listIterator.hasNext() && (item = (ItemStack)listIterator.next()) != null && (SCore.is1v12Less() || !item.getType().equals((Object)Material.LIGHT_BLUE_STAINED_GLASS_PANE))) {
            ++i;
        }
        this.createItem(material, amount, i, displayName, glow, haveEnchant, loreString);
    }

    public void createItem(Material material, int amount, int invSlot, String displayName, boolean glow, boolean haveEnchant, int customTextureTag, String ... loreString) {
        ItemStack item = new ItemStack(material, amount);
        GUI.setIdentifier(item, displayName);
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (glow || haveEnchant) {
            meta = MakeItemGlow.makeGlow(meta);
        }
        ItemFlag additionnalFlag = SCore.is1v20v5Plus() ? ItemFlag.HIDE_ADDITIONAL_TOOLTIP : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
        meta.addItemFlags(new ItemFlag[]{additionnalFlag});
        meta.setDisplayName(StringConverter.coloredString(displayName));
        for (String s : loreString) {
            lore.add(StringConverter.coloredString(s));
        }
        meta.setLore(lore);
        if (!SCore.is1v13Less()) {
            meta.setCustomModelData(Integer.valueOf(customTextureTag));
        }
        item.setItemMeta(meta);
        this.inv.setItem(invSlot, item);
    }

    public void createItem(ItemStack itemS, int amount, int invSlot, String displayName, boolean glow, boolean haveEnchant, String ... loreString) {
        if (itemS == null) {
            itemS = new ItemStack(Material.BARRIER, 1);
        }
        GUI.setIdentifier(itemS, displayName);
        ItemMeta meta = itemS.getItemMeta();
        if (meta == null) {
            meta = new ItemStack(Material.BARRIER, 1).getItemMeta();
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (glow || haveEnchant) {
            meta = MakeItemGlow.makeGlow(meta);
        }
        ItemFlag additionnalFlag = SCore.is1v20v5Plus() ? ItemFlag.HIDE_ADDITIONAL_TOOLTIP : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
        meta.addItemFlags(new ItemFlag[]{additionnalFlag});
        meta.setDisplayName(StringConverter.coloredString(displayName));
        for (String s : loreString) {
            lore.add(StringConverter.coloredString(s));
        }
        meta.setLore(lore);
        itemS.setItemMeta(meta);
        try {
            this.inv.setItem(invSlot, itemS);
        }
        catch (Exception e) {
            Utils.sendConsoleMsg(SCore.plugin, "&cError while creating item in GUI: " + Arrays.toString(e.getStackTrace()));
            ItemStack item = new ItemStack(Material.BARRIER, 1);
            ItemMeta meta2 = item.getItemMeta();
            meta2.setDisplayName(StringConverter.coloredString(displayName));
            lore.add(0, StringConverter.coloredString("&cError while creating this item in GUI"));
            lore.add(1, StringConverter.coloredString("&cPlease check the console"));
            lore.add(2, StringConverter.coloredString("&cIf you think this is a bug"));
            lore.add(3, StringConverter.coloredString("&cPlease report it on the discord"));
            meta2.setLore(lore);
            item.setItemMeta(meta2);
            this.inv.setItem(invSlot, item);
        }
    }

    public void createBackGroundItem(int slot) {
        if (!SCore.is1v13Less()) {
            ItemStack item = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 1);
            if (SCore.is1v20v5Plus()) {
                ItemMeta meta = item.getItemMeta();
                meta.setHideTooltip(true);
                item.setItemMeta(meta);
            }
            this.createItem(item, 1, slot, "&7", true, false, new String[0]);
        } else {
            this.removeItem(slot);
        }
    }

    public void removeItem(int invSlot) {
        this.inv.clear(invSlot);
    }

    public void clear() {
        this.inv.clear();
    }

    public void clearAndSetBackground() {
        this.inv.clear();
        for (int j = 0; j < this.size; ++j) {
            this.createBackGroundItem(j);
        }
    }

    public ItemStack getByIdentifier(String name) {
        for (ItemStack item : this.inv.getContents()) {
            if (item == null || !item.hasItemMeta() || !GUI.isIdentifier(item, name)) continue;
            return item;
        }
        return null;
    }

    public int getSlotByIdentifier(String name) {
        int i = -1;
        for (ItemStack item : this.inv.getContents()) {
            ++i;
            if (item == null || !item.hasItemMeta() || !GUI.isIdentifier(item, name)) continue;
            return i;
        }
        return i;
    }

    public void openGUISync(final Player player) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                player.openInventory(GUI.this.inv);
            }
        };
        Player entity = player;
        SCore.schedulerHook.runEntityTask(runnable, null, (Entity)entity, 0L);
    }

    public String getCurrently(ItemStack item) {
        List lore = item.getItemMeta().getLore();
        for (String s : lore) {
            String deColored = StringConverter.decoloredString(s);
            if (!StringConverter.decoloredString(s).contains(StringConverter.decoloredString(TM.g(Text.EDITOR_CURRENTLY_NAME)))) continue;
            try {
                return StringConverter.decoloredString(s).split(StringConverter.decoloredString(TM.g(Text.EDITOR_CURRENTLY_NAME)) + " ")[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return "";
            }
        }
        return null;
    }

    public String getCurrentlyWithColor(ItemStack item) {
        List lore = item.getItemMeta().getLore();
        for (String s : lore) {
            if (!StringConverter.decoloredString(s).contains(StringConverter.decoloredString(TM.g(Text.EDITOR_CURRENTLY_NAME)))) continue;
            try {
                return StringConverter.deconvertColor(s).split(StringConverter.decoloredString(TM.g(Text.EDITOR_CURRENTLY_NAME)) + " ")[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return "";
            }
        }
        return null;
    }

    public void updateCurrently(ItemStack item, String update, boolean withColor, String editorName) {
        String s;
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        int cpt = 0;
        Iterator iterator = lore.iterator();
        while (iterator.hasNext() && !StringConverter.decoloredString(s = (String)iterator.next()).contains(StringConverter.decoloredString(TM.g(Text.EDITOR_CURRENTLY_NAME)))) {
            ++cpt;
        }
        if (withColor) {
            lore.set(cpt, StringConverter.coloredString(TM.g(Text.EDITOR_CURRENTLY_NAME) + " " + update));
        } else {
            lore.set(cpt, StringConverter.coloredString(TM.g(Text.EDITOR_CURRENTLY_NAME) + " &e" + update));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public void updateItem(int slot, ItemStack item, String identifier) {
        GUI.setIdentifier(item, identifier);
        this.inv.setItem(slot, item);
    }

    public void updateCurrently(ItemStack item, String update, String editorName) {
        this.updateCurrently(item, update, false, editorName);
    }

    public void updateCurrently(ItemStack item, String update) {
        this.updateCurrently(item, update, false, "");
    }

    public String getCurrently(String itemName) {
        return this.getCurrently(this.getByIdentifier(itemName));
    }

    public String getCurrentlyWithColor(String itemName) {
        return this.getCurrentlyWithColor(this.getByIdentifier(itemName));
    }

    public void updateCurrently(String itemName, String update) {
        this.updateCurrently(this.getByIdentifier(itemName), update, itemName);
    }

    public void updateCurrently(String itemName, String update, Boolean withColor) {
        this.updateCurrently(this.getByIdentifier(itemName), update, withColor, itemName);
    }

    public void updateCondition(String name, String condition) {
        ItemStack item = this.getByIdentifier(name);
        if (condition.equals("")) {
            this.updateCurrently(item, "&cNO CONDITION", name);
        } else {
            this.updateCurrently(item, condition, name);
        }
    }

    public String getCondition(String name) {
        if (this.getCurrently(this.getByIdentifier(name)).contains("NO CONDITION")) {
            return "";
        }
        return this.getCurrently(this.getByIdentifier(name));
    }

    public void updateConditionList(String name, List<String> list, String emptyStr) {
        String s;
        ItemStack item = this.getByIdentifier(name);
        ItemMeta toChange = item.getItemMeta();
        ArrayList<String> loreUpdate = new ArrayList<String>();
        Iterator<Object> iterator = toChange.getLore().iterator();
        while (iterator.hasNext() && !StringConverter.deconvertColor(s = (String)iterator.next()).contains(emptyStr) && !StringConverter.deconvertColor(s).startsWith("&6\u27a4 &e")) {
            loreUpdate.add(s);
        }
        if (list.isEmpty()) {
            loreUpdate.add(StringConverter.coloredString(emptyStr));
        } else {
            for (String str : list) {
                loreUpdate.add(StringConverter.coloredString("&6\u27a4 &e" + str));
            }
        }
        toChange.setLore(loreUpdate);
        item.setItemMeta(toChange);
        UpdateItemInGUI.updateItemInGUI(this, name, item.getItemMeta().getDisplayName(), loreUpdate, item.getType());
    }

    public List<String> getConditionList(String name, String emptyStr) {
        ItemStack item = this.getByIdentifier(name);
        ItemMeta iM = item.getItemMeta();
        ArrayList<String> loreUpdate = new ArrayList<String>();
        for (String s : iM.getLore()) {
            if (!s.contains(emptyStr) && !StringConverter.deconvertColor(s).startsWith("&6\u27a4 &e")) continue;
            loreUpdate.add(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : loreUpdate) {
            if ((line = StringConverter.decoloredString(line)).contains(emptyStr)) {
                return new ArrayList<String>();
            }
            result.add(line.replaceAll("\u27a4 ", ""));
        }
        return result;
    }

    public List<String> getConditionListWithColor(String name, String emptyStr) {
        ItemStack item = this.getByIdentifier(name);
        ItemMeta iM = item.getItemMeta();
        ArrayList<String> loreUpdate = new ArrayList<String>();
        for (String s : iM.getLore()) {
            if (!s.contains(emptyStr) && !StringConverter.deconvertColor(s).startsWith("&6\u27a4 &e")) continue;
            loreUpdate.add(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : loreUpdate) {
            if ((line = StringConverter.deconvertColor(line)).contains(emptyStr)) {
                return new ArrayList<String>();
            }
            result.add(line.replaceAll("&6\u27a4 &e", "").replaceAll("&6\u27a4 ", ""));
        }
        return result;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void updateBoolean(String itemName, boolean value) {
        ItemStack item = this.getByIdentifier(itemName);
        if (value) {
            MakeItemGlow.makeGlow(item);
            this.updateCurrently(item, "&aTrue", itemName);
        } else {
            MakeItemGlow.makeUnGlow(item);
            this.updateCurrently(item, "&cFalse", itemName);
        }
    }

    public void changeBoolean(String itemName) {
        ItemStack item = this.getByIdentifier(itemName);
        this.updateBoolean(itemName, !this.getCurrently(item).contains("True"));
    }

    public boolean getBoolean(String itemName) {
        ItemStack item = this.getByIdentifier(itemName);
        return this.getCurrently(item).contains("True");
    }

    public void updateInt(String itemName, int value) {
        ItemStack item = this.getByIdentifier(itemName);
        this.updateCurrently(item, value + "", itemName);
    }

    public int getInt(String itemName) {
        ItemStack item = this.getByIdentifier(itemName);
        if (item == null) {
            throw new NullPointerException("Item with the name: " + itemName + " is null");
        }
        return Integer.parseInt(this.getCurrently(item));
    }

    public void updateDouble(String itemName, double value) {
        ItemStack item = this.getByIdentifier(itemName);
        this.updateCurrently(item, value + "", itemName);
    }

    public double getDouble(String itemName) {
        ItemStack item = this.getByIdentifier(itemName);
        return Double.parseDouble(this.getCurrently(item));
    }

    @Generated
    public Map<String, String> getSubSettings() {
        return this.subSettings;
    }

    @Generated
    public Inventory getInv() {
        return this.inv;
    }

    @Generated
    public void setInv(Inventory inv) {
        this.inv = inv;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    static {
        NEXT_PAGE_MAT = null;
        PREVIOUS_PAGE_MAT = null;
        WRITABLE_BOOK = null;
        CLOCK = null;
        ENCHANTING_TABLE = null;
        HEAD = null;
        GRINDSTONE = null;
        COMPARATOR = null;
        RED = null;
        ORANGE = null;
        GREEN = null;
        YELLOW = null;
        PURPLE = null;
        BLUE = null;
        LIGHTNING_ROD = null;
    }
}

