/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.custom;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.pack.custom.PackHttpInjector;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;

public class PackSettings {
    private UUID uuid;
    private SPlugin sPlugin;
    private String filePath;
    private String customPromptMessage;
    private boolean force;
    private PackHttpInjector injector;
    private HostedPathType hostedPathType;
    private String hostedPath;
    private boolean deleteInitialFile = false;

    public PackSettings(SPlugin sPlugin, UUID uuid, String filePath, String customPromptMessage, boolean force, boolean deleteInitialFile) {
        this.sPlugin = sPlugin;
        this.uuid = uuid;
        this.filePath = filePath;
        this.customPromptMessage = customPromptMessage;
        this.force = force;
        this.injector = new PackHttpInjector(this);
        this.hostedPathType = null;
        this.hostedPath = null;
        this.deleteInitialFile = deleteInitialFile;
    }

    public String getHostedPath() {
        if (this.hostedPath != null) {
            return this.hostedPath;
        }
        if (!GeneralConfig.getInstance().getSelfHostPackIp().isEmpty()) {
            String url = "http://" + GeneralConfig.getInstance().getSelfHostPackIp() + ":" + Bukkit.getServer().getPort() + "/score/" + this.getFileName();
            this.hostedPathType = HostedPathType.EXTERNAL;
            this.hostedPath = url;
            Utils.sendConsoleMsg("&7Pack hosted at: &e" + url + " (with self host IP)");
            this.logSelfHostingWarning();
            return url;
        }
        String url = "http://" + PackSettings.getExternalIP() + ":" + Bukkit.getServer().getPort() + "/score/" + this.getFileName();
        if ((this.hostedPathType == null || this.hostedPathType == HostedPathType.EXTERNAL) && PackSettings.isHttpURLReachable(url, 10000)) {
            this.hostedPathType = HostedPathType.EXTERNAL;
            this.hostedPath = url;
            Utils.sendConsoleMsg("&7Pack hosted at: &e" + url + " (with external IP)");
            return url;
        }
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("&cCannot connect to &6" + url);
        }
        try {
            url = "http://" + InetAddress.getLocalHost().getHostAddress() + ":" + Bukkit.getServer().getPort() + "/score/" + this.getFileName();
            if ((this.hostedPathType == null || this.hostedPathType == HostedPathType.LOCAL_IP) && PackSettings.isHttpURLReachable(url, 10000)) {
                this.hostedPathType = HostedPathType.LOCAL_IP;
                this.hostedPath = url;
                Utils.sendConsoleMsg("&7Pack hosted at: &e" + url + " (with local IP)");
                this.logSelfHostingWarning();
                return url;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("&cCannot connect to &6" + url);
        }
        try {
            url = "http://" + InetAddress.getLocalHost().getHostAddress() + ":" + Bukkit.getServer().getPort() + "/score/" + this.getFileName();
            if ((this.hostedPathType == null || this.hostedPathType == HostedPathType.LOCAL_IP) && PackSettings.isHttpURLReachable(url, 10000)) {
                this.hostedPathType = HostedPathType.LOCAL_IP;
                this.hostedPath = url;
                Utils.sendConsoleMsg("&7Pack hosted at: &e" + url + " (with local IP)");
                this.logSelfHostingWarning();
                return url;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("&cCannot connect to &6" + url);
        }
        url = "http://localhost:" + Bukkit.getServer().getPort() + "/score/" + this.getFileName();
        if ((this.hostedPathType == null || this.hostedPathType == HostedPathType.LOCALHOST) && PackSettings.isHttpURLReachable(url, 10000)) {
            this.hostedPathType = HostedPathType.LOCALHOST;
            this.hostedPath = url;
            Utils.sendConsoleMsg("&7Pack hosted at: &e" + url + " (with localhost)");
            return url;
        }
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("&cCannot connect to &6" + url);
        }
        return null;
    }

    public static boolean isHttpURLReachable(String urlString, int timeout) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
                Utils.sendConsoleMsg("&7Debug response output: &7" + responseCode);
            }
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException e) {
            if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
                Utils.sendConsoleMsg("&7Debug &e" + urlString + " &7- &e" + e.getMessage());
            }
            return e.getMessage().contains("Unexpected end of file from server");
        }
    }

    public String getFileName() {
        return this.getFile().getName().replaceAll(" ", "_").replaceAll(".zip", "");
    }

    public File getFile() {
        return new File(this.filePath);
    }

    public static String getMinecraftServerIP() {
        try {
            InetSocketAddress address = new InetSocketAddress(Bukkit.getServer().getIp(), Bukkit.getServer().getPort());
            return address.getAddress().getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public static String getExternalIP() {
        String externalIP = "null";
        try {
            URL url = new URL("https://api.ipify.org");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            externalIP = reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return externalIP;
    }

    private void logSelfHostingWarning() {
        Utils.sendConsoleMsg("&6WARNING: &7Self-hosting may not work on all hosting providers due to firewall/NAT restrictions.");
        Utils.sendConsoleMsg("&7If the resource pack fails to load for players, disable self-hosting by setting &e'selfHostPack: false' &7in your config.yml");
        Utils.sendConsoleMsg("&7and configure &e'texturesPackUrl' &7with an external hosting URL (e.g., Dropbox, GitHub Pages).");
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public SPlugin getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Generated
    public String getCustomPromptMessage() {
        return this.customPromptMessage;
    }

    @Generated
    public boolean isForce() {
        return this.force;
    }

    @Generated
    public PackHttpInjector getInjector() {
        return this.injector;
    }

    @Generated
    public HostedPathType getHostedPathType() {
        return this.hostedPathType;
    }

    @Generated
    public boolean isDeleteInitialFile() {
        return this.deleteInitialFile;
    }

    @Generated
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public static enum HostedPathType {
        EXTERNAL,
        LOCAL_IP,
        LOCALHOST;

    }
}

