/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.particles.commands;

import com.ssomar.particles.commands.Parameter;
import com.ssomar.particles.commands.ParticleDisplay;
import com.ssomar.score.SCore;
import com.ssomar.score.utils.numbers.NTools;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;

public class Parameters
extends ArrayList<Parameter> {
    private boolean requirePlugin;
    private boolean requireDisplay;
    private ParticleDisplay display;

    public void init(Method method) {
        CachingParanamer info = new CachingParanamer(new AnnotationParanamer(new BytecodeReadingParanamer()));
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        String[] parameterNames = info.lookupParameterNames(method);
        int i = 0;
        for (String parameter : parameterNames) {
            if (parameter.equals("plugin")) {
                this.requirePlugin = true;
                ++i;
                continue;
            }
            if (parameter.equals("display")) {
                this.requireDisplay = true;
                ++i;
                continue;
            }
            Object o = null;
            switch (parameters[i].getType().getName()) {
                case "int": {
                    o = 0;
                    break;
                }
                case "double": {
                    o = 0.0;
                    break;
                }
                case "boolean": {
                    o = false;
                    break;
                }
                case "java.lang.String": {
                    o = "";
                }
            }
            this.add(new Parameter<Object>(parameter, o, ""));
            ++i;
        }
    }

    public void load(String[] parameters, Entity entity, Location loc) {
        for (Parameter p : this) {
            p.load(parameters);
        }
        if (this.requireDisplay) {
            MemoryConfiguration config = new MemoryConfiguration();
            ConfigurationSection section = config.createSection("section");
            for (String s : parameters) {
                String[] sp = s.split(":");
                if (sp.length != 2) continue;
                String value = sp[1];
                Optional<Double> optNumber = NTools.getDouble(value);
                if (optNumber.isPresent()) {
                    section.set(sp[0], (Object)optNumber.get());
                    continue;
                }
                section.set(sp[0], (Object)sp[1]);
            }
            this.display = ParticleDisplay.edit(ParticleDisplay.simple(loc, Particle.FLAME), section);
            if (entity != null) {
                this.display.withEntity(entity);
            }
        }
    }

    public Object getParameterValue(String name) {
        for (Parameter p : this) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    public Object[] getParametersValues() {
        int size = this.size();
        if (this.requirePlugin) {
            ++size;
        }
        if (this.requireDisplay) {
            ++size;
        }
        Object[] values = new Object[size];
        int i = 0;
        if (this.requirePlugin) {
            values[i] = SCore.plugin;
            ++i;
        }
        for (Parameter p : this) {
            values[i] = p.getValue();
            ++i;
        }
        if (this.requireDisplay) {
            values[i] = this.display;
        }
        return values;
    }
}

