/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandManager;
import com.ssomar.score.commands.runnable.CommandsHandler;
import com.ssomar.score.commands.runnable.RunConsoleCommand;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class RunCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String brutCommand;
    private StringPlaceholder sp;
    private int delay;
    private long runTime;
    private ActionInfo aInfo;
    private UUID uuid;
    private ScheduledTask task;

    public RunCommand(String brutCommand, int delay, ActionInfo aInfo) {
        this.brutCommand = brutCommand;
        this.aInfo = aInfo;
        this.sp = aInfo.getSp();
        this.delay = delay;
        this.runTime = -1L;
        this.uuid = UUID.randomUUID();
        this.task = null;
        this.pickupInfo();
    }

    public RunCommand(String brutCommand, long runTime, ActionInfo aInfo) {
        this.brutCommand = brutCommand;
        this.aInfo = aInfo;
        this.sp = aInfo.getSp();
        this.uuid = UUID.randomUUID();
        this.task = null;
        this.pickupInfo();
        long current = System.currentTimeMillis();
        long diff = runTime - current;
        this.delay = diff == 0L ? 0 : (int)(diff / 50L);
        this.runTime = -1L;
    }

    public void run() {
        if (this.delay == 0) {
            this.runTime = 0L;
            this.runGetManager();
        } else if (this.runTime != -1L) {
            this.delay = (int)((this.runTime - System.currentTimeMillis()) / 50L);
            if (this.delay < 0) {
                this.delay = 0;
            }
            this.runDelayedCommand();
        } else {
            this.runTime = System.currentTimeMillis() + (long)this.delay * 50L;
            this.runDelayedCommand();
        }
    }

    public abstract void runGetManager();

    public void runCommand(final CommandManager manager) {
        Runnable runnable = new Runnable(){
            final /* synthetic */ RunCommand this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Optional commandOpt;
                String finalCommand = this.this$0.getBrutCommand();
                int later = 0;
                HashMap<Integer, String> placeholdersToReplaceLatter = new HashMap<Integer, String>();
                if (finalCommand.contains("%around_")) {
                    String[] split = finalCommand.split(" ");
                    for (String s : split) {
                        String regex = "\\S*%[a-zA-Z0-9_]*\\S*[{(]*%around_\\S*%[})]*";
                        if (!s.matches(regex)) continue;
                        finalCommand = finalCommand.replace(s, "PLACEHOLDER_TO_REPLACE_LATER_" + later);
                        s = this.this$0.getSp().replacePlaceholder(s, false);
                        placeholdersToReplaceLatter.put(later, s);
                        ++later;
                    }
                }
                if (!finalCommand.startsWith("WHILE") && !finalCommand.startsWith("IF")) {
                    finalCommand = this.this$0.getSp().replacePlaceholder(finalCommand);
                }
                for (Map.Entry entry : placeholdersToReplaceLatter.entrySet()) {
                    finalCommand = finalCommand.replace("PLACEHOLDER_TO_REPLACE_LATER_" + entry.getKey(), (CharSequence)entry.getValue());
                }
                if (this.this$0.getBrutCommand().contains("ei giveslot")) {
                    try {
                        String playeName = finalCommand.split("ei giveslot ")[1].split(" ")[0];
                        Player player = Bukkit.getServer().getPlayer(playeName);
                        CommandsHandler.getInstance().addStopPickup(player, 20);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((commandOpt = manager.getCommand(finalCommand)).isPresent()) {
                    SCommand sCommand = (SCommand)commandOpt.get();
                    SCommandToExec commandToExec = new SCommandToExec(sCommand);
                    if (!sCommand.isNewSettingsMode()) {
                        List<String> args = manager.getArgs(sCommand, finalCommand);
                        Optional<String> error = sCommand.verify(args, true);
                        if (error.isPresent()) {
                            this.this$0.aInfo.getDebugers().sendDebug(error.get());
                            return;
                        }
                        commandToExec.setOtherArgs(args);
                    } else {
                        commandToExec.extractSettings(finalCommand);
                    }
                    this.this$0.runCommand(commandToExec);
                    return;
                }
                if (finalCommand.trim().isEmpty()) {
                    return;
                }
                if (finalCommand.charAt(0) == '/') {
                    finalCommand = finalCommand.substring(1);
                }
                if (finalCommand.contains("\"color\"") && finalCommand.contains("title")) {
                    finalCommand = StringConverter.deconvertColor(finalCommand);
                }
                RunConsoleCommand.runConsoleCommand(finalCommand, this.this$0.aInfo.isSilenceOutput());
            }
        };
        this.executeRunnable(runnable);
    }

    public void runDelayedCommand() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RunCommand.this.insideDelayedCommand();
            }
        };
        this.task = SCore.schedulerHook.runTask(runnable, this.getDelay());
        if (this.getDelay() > 0) {
            CommandsHandler.getInstance().addDelayedCommand(this);
        }
    }

    public abstract void insideDelayedCommand();

    public abstract void executeRunnable(Runnable var1);

    public abstract void runCommand(SCommandToExec var1);

    public abstract void pickupInfo();

    public String getBrutCommand() {
        return this.brutCommand;
    }

    public void setBrutCommand(String brutCommand) {
        this.brutCommand = brutCommand;
    }

    public StringPlaceholder getSp() {
        return this.sp;
    }

    public void setSp(StringPlaceholder sp) {
        this.sp = sp;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    public ActionInfo getaInfo() {
        return this.aInfo;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public void setTask(ScheduledTask task) {
        this.task = task;
    }
}

