/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.features.custom.detailedblocks.DetailedBlocks;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.safebreak.SafeBreak;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VeinBreaker
extends BlockCommand {
    public VeinBreaker() {
        CommandSetting maxVeinSize = new CommandSetting("maxVeinSize", 0, Integer.class, (Object)10, true);
        CommandSetting triggerEvent = new CommandSetting("triggerEvent", 1, Boolean.class, (Object)true, true);
        List<CommandSetting> settings = this.getSettings();
        settings.add(maxVeinSize);
        settings.add(triggerEvent);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(final Player p, final @NotNull Block block, SCommandToExec sCommandToExec) {
        final int maxVeinSize = (Integer)sCommandToExec.getSettingValue("maxVeinSize");
        final boolean triggerEvent = (Boolean)sCommandToExec.getSettingValue("triggerEvent");
        final ActionInfo aInfo = sCommandToExec.getActionInfo();
        final Material oldMaterial = aInfo.getOldBlockMaterial();
        Runnable runnable3 = new Runnable(){
            final /* synthetic */ VeinBreaker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (aInfo.isEventFromCustomBreakCommand()) {
                    return;
                }
                DetailedBlocks whiteList = aInfo.getDetailedBlocks();
                if (whiteList != null && !whiteList.isValid(block, Optional.empty(), null, new StringPlaceholder(), oldMaterial, Optional.empty())) {
                    p.sendMessage(ChatColor.RED + "This block is not allowed to be broken ! : " + block.getType().name());
                    return;
                }
                UUID pUUID = null;
                if (p != null) {
                    pUUID = p.getUniqueId();
                }
                SafeBreak.breakBlockWithEvent(block, pUUID, aInfo.getSlot(), true, triggerEvent, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE);
                List<Block> vein = this.this$0.getVein(block, oldMaterial, maxVeinSize);
                for (Block b : vein) {
                    SafeBreak.breakBlockWithEvent(b, pUUID, aInfo.getSlot(), true, triggerEvent, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE);
                }
            }
        };
        SCore.schedulerHook.runLocationTask(runnable3, block.getLocation(), 1L);
    }

    public List<Block> getVein(Block block, Material oldMaterial, int veinSize) {
        ArrayList<Block> result = new ArrayList<Block>();
        this.fillVein(result, block, oldMaterial, veinSize);
        return result;
    }

    public void fillVein(List<Block> vein, Block block, Material oldMaterial, int veinSize) {
        Location loc = block.getLocation();
        ArrayList<Location> toCheck = new ArrayList<Location>();
        toCheck.add(loc.clone().add(0.0, 1.0, 0.0));
        toCheck.add(loc.clone().add(0.0, -1.0, 0.0));
        toCheck.add(loc.clone().add(0.0, 0.0, 1.0));
        toCheck.add(loc.clone().add(0.0, 0.0, -1.0));
        toCheck.add(loc.clone().add(1.0, 0.0, 0.0));
        toCheck.add(loc.clone().add(-1.0, 0.0, 0.0));
        for (Location l : toCheck) {
            if (vein.size() >= veinSize) {
                return;
            }
            Block newBlock = l.getBlock();
            if (!newBlock.getType().equals((Object)oldMaterial) || vein.contains(newBlock)) continue;
            vein.add(newBlock);
            this.fillVein(vein, newBlock, oldMaterial, veinSize);
        }
        int radius = 1;
        for (int y = -radius; y < radius + 1; ++y) {
            for (int x = -radius; x < radius + 1; ++x) {
                for (int z = -radius; z < radius + 1; ++z) {
                    Block newBlock;
                    if (y == 0 && z == 0 && x == 0) continue;
                    if (vein.size() >= veinSize) {
                        return;
                    }
                    Location newLoc = loc.clone();
                    newLoc.add((double)x, (double)y, (double)z);
                    if (toCheck.contains(newLoc) || !(newBlock = newLoc.getBlock()).getType().equals((Object)oldMaterial) || vein.contains(newBlock)) continue;
                    vein.add(newBlock);
                    this.fillVein(vein, newBlock, oldMaterial, veinSize);
                }
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("VEIN_BREAKER");
        return names;
    }

    @Override
    public String getTemplate() {
        return "VEIN_BREAKER maxVeinSize:10 triggerEvent:true";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

