/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AddTemporaryAttribute
extends MixedCommand {
    public AddTemporaryAttribute() {
        CommandSetting attribute = new CommandSetting("attribute", 0, String.class, (Object)"SCALE");
        CommandSetting amount = new CommandSetting("amount", 1, Double.class, (Object)1);
        CommandSetting operation = new CommandSetting("operation", 2, String.class, (Object)"ADD_NUMBER");
        CommandSetting timeinticks = new CommandSetting("timeinticks", 3, Long.class, (Object)20);
        List<CommandSetting> settings = this.getSettings();
        settings.add(attribute);
        settings.add(amount);
        settings.add(operation);
        settings.add(timeinticks);
        this.setNewSettingsMode(true);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ADD_TEMPORARY_ATTRIBUTE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "ADD_TEMPORARY_ATTRIBUTE {attribute} {amount} {operation} {time in ticks}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    @Override
    public void run(Player p, Entity entity, SCommandToExec sCommandToExec) {
        AttributeModifier.Operation operation;
        Attribute attrCheck = AttributeUtils.getAttribute((String)sCommandToExec.getSettingValue("attribute"));
        if (attrCheck == null) {
            SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field attribute: " + sCommandToExec.getSettingValue("attribute"));
            return;
        }
        try {
            Double.parseDouble(sCommandToExec.getSettingValue("amount").toString());
        }
        catch (Exception e) {
            SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field attribute amount: " + sCommandToExec.getSettingValue("amount").toString());
            return;
        }
        switch (sCommandToExec.getSettingValue("operation").toString().toUpperCase()) {
            case "ADD_NUMBER": {
                operation = AttributeModifier.Operation.ADD_NUMBER;
                break;
            }
            case "ADD_SCALAR": {
                operation = AttributeModifier.Operation.ADD_SCALAR;
                break;
            }
            case "MULTIPLY_SCALAR_1": {
                operation = AttributeModifier.Operation.MULTIPLY_SCALAR_1;
                break;
            }
            default: {
                SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field attribute operation: " + sCommandToExec.getSettingValue("operation").toString().toUpperCase());
                return;
            }
        }
        try {
            Long.parseLong(sCommandToExec.getSettingValue("timeinticks").toString());
        }
        catch (Exception e) {
            SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field tick duration: " + sCommandToExec.getSettingValue("timeinticks").toString());
            return;
        }
        AttributeInstance attrInstance = null;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            attrInstance = livingEntity.getAttribute(attrCheck);
        }
        NamespacedKey key = new NamespacedKey((Plugin)SCore.plugin, "mod_" + UUID.randomUUID());
        final AttributeModifier tempModifier = new AttributeModifier(key, Double.parseDouble(sCommandToExec.getSettingValue("amount").toString()), operation);
        attrInstance.addModifier(tempModifier);
        final AttributeInstance finalAttrInstance = attrInstance;
        new BukkitRunnable(this){
            final /* synthetic */ AddTemporaryAttribute this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                finalAttrInstance.removeModifier(tempModifier);
            }
        }.runTaskLater((Plugin)SCore.plugin, Long.parseLong(sCommandToExec.getSettingValue("timeinticks").toString()));
    }
}

