/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DamageBoost
extends MixedCommand {
    private static final Boolean DEBUG = false;
    private static DamageBoost instance;
    private final Map<UUID, List<Double>> activeBoosts = new HashMap<UUID, List<Double>>();

    public static DamageBoost getInstance() {
        if (instance == null) {
            instance = new DamageBoost();
        }
        return instance;
    }

    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final double boost = Double.valueOf(args.get(0));
        final int time = Double.valueOf(args.get(1)).intValue();
        final UUID uuid = receiver.getUniqueId();
        SsomarDev.testMsg("ADD receiver: " + receiver.getUniqueId() + " Damage Boost: " + boost + " for " + time + " ticks", DEBUG);
        if (this.activeBoosts.containsKey(uuid)) {
            this.activeBoosts.get(uuid).add(boost);
        } else {
            this.activeBoosts.put(uuid, new ArrayList<Double>(Collections.singletonList(boost)));
        }
        Runnable runnable3 = new Runnable(){
            final /* synthetic */ DamageBoost this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SsomarDev.testMsg("REMOVE receiver: " + uuid + " Damage Boost: " + boost + " for " + time + " ticks", DEBUG);
                if (this.this$0.activeBoosts.containsKey(uuid)) {
                    if (((List)this.this$0.activeBoosts.get(uuid)).size() > 1) {
                        ((List)this.this$0.activeBoosts.get(uuid)).remove(boost);
                    } else {
                        this.this$0.activeBoosts.remove(uuid);
                    }
                }
            }
        };
        SCore.schedulerHook.runTask(runnable3, time);
    }

    public double getNewDamage(UUID uuid, double damage) {
        SsomarDev.testMsg("GET NEW DAMAGE FOR: " + uuid + " Damage: " + damage, DEBUG);
        if (DamageBoost.getInstance().getActiveBoosts().containsKey(uuid)) {
            SsomarDev.testMsg("DamageBoostEvent base: " + damage, DEBUG);
            double boost = 0.0;
            for (double d : DamageBoost.getInstance().getActiveBoosts().get(uuid)) {
                boost += d;
            }
            SsomarDev.testMsg("DamageBoostEvent bost: " + boost, DEBUG);
            double averagePercent = boost / 100.0;
            damage += damage * averagePercent;
            SsomarDev.testMsg("DamageBoostEvent modified " + damage, DEBUG);
        }
        return damage;
    }

    public Optional<String> onRequestPlaceholder(@NotNull OfflinePlayer player, String params) {
        if (params.startsWith("cmd-damage-boost")) {
            return Optional.of(String.valueOf(this.getNewDamage(player.getUniqueId(), 1.0)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 2) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = DamageBoost.checkDouble(args.get(0), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        ArgumentChecker ac2 = DamageBoost.checkInteger(args.get(1), isFinalVerification, this.getTemplate());
        if (!ac2.isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DAMAGE_BOOST");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DAMAGE_BOOST {modification in percentage example 100} {timeinticks}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    @Generated
    public Map<UUID, List<Double>> getActiveBoosts() {
        return this.activeBoosts;
    }
}

