/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.CommmandThatRunsCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class HitscanEntities
extends MixedCommand {
    public HitscanEntities() {
        CommandSetting range = new CommandSetting("range", -1, Double.class, (Object)5.0);
        CommandSetting radius = new CommandSetting("radius", -1, Double.class, (Object)0.0);
        CommandSetting pitch = new CommandSetting("pitch", -1, Double.class, (Object)0.0);
        CommandSetting yaw = new CommandSetting("yaw", -1, Double.class, (Object)0.0);
        CommandSetting leftRightShift = new CommandSetting("leftRightShift", -1, Double.class, (Object)0.0);
        CommandSetting yShift = new CommandSetting("yShift", -1, Double.class, (Object)0.0);
        CommandSetting throughBlocks = new CommandSetting("throughBlocks", -1, Boolean.class, (Object)true);
        CommandSetting throughEntities = new CommandSetting("throughEntities", -1, Boolean.class, (Object)true);
        CommandSetting limit = new CommandSetting("limit", -1, Integer.class, (Object)-1);
        CommandSetting sort = new CommandSetting("sort", -1, String.class, (Object)"NEAREST");
        List<CommandSetting> settings = this.getSettings();
        settings.add(range);
        settings.add(radius);
        settings.add(pitch);
        settings.add(yaw);
        settings.add(leftRightShift);
        settings.add(yShift);
        settings.add(throughEntities);
        settings.add(throughBlocks);
        settings.add(limit);
        settings.add(sort);
        this.setNewSettingsMode(true);
        this.setCanExecuteCommands(true);
    }

    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<Entity> entities = HitscanEntities.runHitscan(receiver, sCommandToExec, false);
        CommmandThatRunsCommand.runEntityCommands(entities, sCommandToExec.getOtherArgs(), sCommandToExec.getActionInfo());
    }

    public static List<Entity> runHitscan(Entity receiver, SCommandToExec sCommandToExec, boolean playerOnly) {
        List<Object> entities = new ArrayList<Entity>();
        double range = (Double)sCommandToExec.getSettingValue("range");
        double radius = (Double)sCommandToExec.getSettingValue("radius");
        double pitch = (Double)sCommandToExec.getSettingValue("pitch");
        double yaw = (Double)sCommandToExec.getSettingValue("yaw");
        double leftRightShift = (Double)sCommandToExec.getSettingValue("leftRightShift");
        double yShift = (Double)sCommandToExec.getSettingValue("yShift");
        boolean throughBlocks = (Boolean)sCommandToExec.getSettingValue("throughBlocks");
        boolean throughEntities = (Boolean)sCommandToExec.getSettingValue("throughEntities");
        int limit = (Integer)sCommandToExec.getSettingValue("limit");
        String sort = (String)sCommandToExec.getSettingValue("sort");
        if (receiver instanceof LivingEntity) {
            LivingEntity fromEntity = (LivingEntity)receiver;
            Location startLocation = fromEntity.getEyeLocation().clone();
            startLocation.setPitch((float)((double)startLocation.getPitch() + pitch));
            startLocation.setYaw((float)((double)startLocation.getYaw() + yaw));
            Vector offset = HitscanEntities.calculateOffset(fromEntity, leftRightShift, yShift);
            startLocation.add(offset);
            List nearbyEntities = (List)startLocation.getWorld().getNearbyEntities(startLocation, range, range, range);
            for (Entity entity : nearbyEntities) {
                if (entity == receiver || playerOnly && !(entity instanceof Player) || !playerOnly && entity instanceof Player || entity.equals((Object)fromEntity) || !(entity instanceof LivingEntity)) continue;
                Location hitPosition = null;
                hitPosition = HitscanEntities.isWithinCylinder(startLocation, entity, range, radius);
                if (hitPosition == null) {
                    SsomarDev.testMsg("ENTITY > " + entity.getType() + " NOT IN CYLINDER", true);
                    continue;
                }
                SsomarDev.testMsg("CHECK ENTITY > " + entity.getName(), true);
                boolean hitSuccess = HitscanEntities.performRaytraceChecks(fromEntity, startLocation, hitPosition, (LivingEntity)entity, range, radius, throughBlocks, throughEntities);
                if (!hitSuccess) continue;
                SsomarDev.testMsg("YESSS HITSCAN > " + entity.getType(), true);
                entities.add(entity);
            }
        }
        if (sort.equalsIgnoreCase("NEAREST")) {
            entities.sort((e1, e2) -> {
                double d1 = e1.getLocation().distance(receiver.getLocation());
                double d2 = e2.getLocation().distance(receiver.getLocation());
                return Double.compare(d1, d2);
            });
        } else if (sort.equalsIgnoreCase("RANDOM")) {
            Collections.shuffle(entities);
        }
        if (limit > 0 && entities.size() > limit) {
            entities = entities.subList(0, limit);
        }
        return entities;
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    private static Vector calculateOffset(LivingEntity fromEntity, double leftRightDisplacement, double yDisplacement) {
        Vector offset = new Vector();
        Vector rightDirection = fromEntity.getLocation().getDirection().crossProduct(new Vector(0, 1, 0)).normalize();
        offset.add(rightDirection.multiply(leftRightDisplacement));
        offset.add(new Vector(0.0, yDisplacement, 0.0));
        return offset;
    }

    private static Location isWithinCylinder(Location start, Entity target, double range, double radius) {
        Vector direction = start.getDirection().normalize();
        RayTraceResult rayTraceResult = start.getWorld().rayTraceEntities(start, direction, range, radius, entity -> entity.equals((Object)target));
        if (rayTraceResult != null) {
            return rayTraceResult.getHitPosition().toLocation(start.getWorld());
        }
        return null;
    }

    private static boolean isWithinCylinder(Location start, Location target, double range, double radius) {
        Vector direction = start.getDirection().normalize();
        Vector toTarget = target.toVector().subtract(start.toVector());
        double distanceAlongAxis = toTarget.dot(direction);
        if (distanceAlongAxis < 0.0 || distanceAlongAxis > range) {
            return false;
        }
        Vector closestPoint = direction.multiply(distanceAlongAxis).add(start.toVector());
        double distanceToAxis = closestPoint.distance(target.toVector());
        return distanceToAxis <= radius;
    }

    private static boolean performRaytraceChecks(LivingEntity fromEntity, Location startLocation, Location hitPosition, LivingEntity target, double range, double radius, boolean throughBlocks, boolean throughEntities) {
        if (throughBlocks && throughEntities) {
            return true;
        }
        Location shooterEyeLocation = startLocation;
        Location targetBodyLocation = target.getLocation();
        double height = target.getHeight();
        double heightDic = height / 4.0;
        ArrayList<Location> targetLocs = new ArrayList<Location>();
        if (radius <= heightDic) {
            SsomarDev.testMsg("hitpost: " + hitPosition, true);
            targetLocs.add(hitPosition);
        }
        targetLocs.add(targetBodyLocation.clone());
        targetLocs.add(targetBodyLocation.clone().add(0.0, heightDic * 1.0, 0.0));
        targetLocs.add(targetBodyLocation.clone().add(0.0, heightDic * 2.0, 0.0));
        targetLocs.add(targetBodyLocation.clone().add(0.0, heightDic * 3.0, 0.0));
        targetLocs.add(targetBodyLocation.clone().add(0.0, heightDic * 4.0, 0.0));
        for (Location targetLoc : targetLocs) {
            if (!HitscanEntities.isWithinCylinder(startLocation, targetLoc.clone(), range, radius)) continue;
            Vector dir = targetLoc.clone().subtract(startLocation).toVector().normalize();
            RayTraceResult rayTraceResult = null;
            if (!throughBlocks && !throughEntities) {
                rayTraceResult = startLocation.getWorld().rayTrace(shooterEyeLocation, dir, shooterEyeLocation.distance(targetBodyLocation), FluidCollisionMode.NEVER, true, 0.1, entity -> !entity.equals((Object)fromEntity) && !entity.equals((Object)target));
            } else if (throughBlocks) {
                SsomarDev.testMsg("TEST throughBlocks tEntity > " + target.getType() + " from > " + fromEntity + " eye > " + shooterEyeLocation + " dir > " + dir + " exclude > " + target, true);
                double distance = shooterEyeLocation.distance(targetBodyLocation);
                rayTraceResult = startLocation.getWorld().rayTraceEntities(shooterEyeLocation, dir, distance, entity -> !entity.equals((Object)fromEntity) && !entity.equals((Object)target));
            } else {
                rayTraceResult = fromEntity.getWorld().rayTraceBlocks(shooterEyeLocation, dir, shooterEyeLocation.distance(targetBodyLocation), FluidCollisionMode.NEVER);
            }
            if (rayTraceResult != null) continue;
            SsomarDev.testMsg("entity : " + target.getType() + " loc " + targetLoc, true);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("HITSCAN_ENTITIES");
        return names;
    }

    @Override
    public String getTemplate() {
        return "HITSCAN_ENTITIES range:5 radius:0 pitch:0 yaw:0 leftRightShift:0 yShift:0 throughBlocks:true throughEntities:true COMMANDS HERE";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

