/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.backward_compatibility.AttributeAdditionMode;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AddItemAttribute
extends PlayerCommand {
    public AddItemAttribute() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)0);
        slot.setSlot(true);
        Attribute att = null;
        att = SCore.is1v21v2Plus() ? Attribute.MAX_HEALTH : AttributeUtils.getAttribute("GENERIC_MAX_HEALTH");
        CommandSetting attribute = new CommandSetting("attribute", 1, AttributeUtils.class, (Object)att);
        CommandSetting value = new CommandSetting("value", 2, Double.class, (Object)1.0);
        CommandSetting equipmentSlot = new CommandSetting("equipmentSlot", 3, EquipmentSlot.class, null);
        CommandSetting mode = new CommandSetting("mode", -1, AttributeAdditionMode.class, (Object)AttributeAdditionMode.ADD);
        CommandSetting affectDefaultAttributes = new CommandSetting("affectDefaultAttributes", -1, Boolean.class, (Object)false);
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(attribute);
        settings.add(value);
        settings.add(equipmentSlot);
        settings.add(mode);
        settings.add(affectDefaultAttributes);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        Attribute attribute = (Attribute)sCommandToExec.getSettingValue("attribute");
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        double value = (Double)sCommandToExec.getSettingValue("value");
        EquipmentSlot equipmentSlot = (EquipmentSlot)sCommandToExec.getSettingValue("equipmentSlot");
        AttributeAdditionMode mode = (AttributeAdditionMode)((Object)sCommandToExec.getSettingValue("mode"));
        boolean affectDefaultAttributes = (Boolean)sCommandToExec.getSettingValue("affectDefaultAttributes");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (attribute == null || item == null || item.getType() == Material.AIR) {
            SsomarDev.testMsg("Error in the command ADD_ATTRIBUTE please check the attribute or the item > att:" + attribute + " item:" + item, true);
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        ItemMeta itemmeta = item.getItemMeta();
        AttributeModifier newModifier = new AttributeModifier(UUID.randomUUID(), "ScoreAttribute", value, AttributeModifier.Operation.ADD_NUMBER, equipmentSlot);
        LinkedHashMap<Attribute, AttributeModifier> map = new LinkedHashMap<Attribute, AttributeModifier>();
        map.put(attribute, newModifier);
        AttributeUtils.addAttributeOnItemMeta(itemmeta, item.getType(), map, true, true, mode, affectDefaultAttributes);
        item.setItemMeta(itemmeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ADD_ITEM_ATTRIBUTE");
        names.add("ADD_ATTRIBUTE");
        names.add("ADDITEMATTRIBUTE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "ADD_ITEM_ATTRIBUTE slot:-1 attribute:GENERIC_MAX_HEALTH value:1.0 equipmentSlot:HAND mode:ADD affectDefaultAttributes:false";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

