/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.events.PlayerCustomLaunchEntityEvent;
import com.ssomar.score.projectiles.SProjectile;
import com.ssomar.score.projectiles.SProjectileType;
import com.ssomar.score.projectiles.manager.SProjectilesManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Launch
extends PlayerCommand {
    public Launch() {
        CommandSetting projectileType = new CommandSetting("projectile", 0, String.class, null);
        CommandSetting angleRotationVertical = new CommandSetting("angleRotationVertical", 1, Double.class, (Object)0.0);
        CommandSetting angleRotationHorizontal = new CommandSetting("angleRotationHorizontal", 2, Double.class, (Object)0.0);
        CommandSetting velocity = new CommandSetting("velocity", -1, Double.class, (Object)1.0);
        List<CommandSetting> settings = this.getSettings();
        settings.add(projectileType);
        settings.add(angleRotationVertical);
        settings.add(angleRotationHorizontal);
        settings.add(velocity);
        this.setNewSettingsMode(true);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        String projectileType = (String)sCommandToExec.getSettingValue("projectile");
        double rotationVertical = (Double)sCommandToExec.getSettingValue("angleRotationVertical");
        double rotationHorizontal = (Double)sCommandToExec.getSettingValue("angleRotationHorizontal");
        double velocity = (Double)sCommandToExec.getSettingValue("velocity");
        if (projectileType == null) {
            receiver.launchProjectile(Arrow.class);
        } else {
            try {
                Projectile entity = null;
                receiver.setMetadata("cancelProjectileEvent", (MetadataValue)new FixedMetadataValue((Plugin)SCore.plugin, (Object)7772));
                Optional projectileOptional = null;
                SProjectile projectile = null;
                if (SProjectileType.getProjectilesClasses().containsKey(projectileType.toUpperCase())) {
                    entity = receiver.launchProjectile(SProjectileType.getProjectilesClasses().get(projectileType.toUpperCase()));
                } else {
                    projectileOptional = SProjectilesManager.getInstance().getLoadedObjectWithID(projectileType);
                    if (projectileOptional.isPresent()) {
                        projectile = (SProjectile)projectileOptional.get();
                        entity = receiver.launchProjectile(SProjectileType.getProjectilesClasses().get(((SProjectileType)((Object)((Optional)projectile.getType().getValue()).get())).getValidNames()[0]));
                    } else {
                        entity = receiver.launchProjectile(Arrow.class);
                    }
                }
                try {
                    if (entity instanceof ShulkerBullet && SCore.is1v21v6Plus()) {
                        ShulkerBullet bullet = (ShulkerBullet)entity;
                        bullet.setTarget(null);
                    }
                }
                catch (Exception e) {
                    entity = receiver.launchProjectile(Arrow.class);
                }
                if (entity instanceof Firework) {
                    entity.remove();
                    EntityType fireworkType = SCore.is1v20v5Plus() ? EntityType.FIREWORK_ROCKET : EntityType.valueOf((String)"FIREWORK");
                    entity = receiver.getWorld().spawnEntity(receiver.getEyeLocation(), fireworkType);
                    Firework firework = (Firework)entity;
                    firework.setShotAtAngle(true);
                }
                if (!SCore.is1v13Less()) {
                    Vector eyeVector;
                    Location loc = receiver.getEyeLocation();
                    float pitch = loc.getPitch();
                    float yaw = loc.getYaw();
                    float newPitch = (float)((double)pitch + rotationHorizontal);
                    float newYaw = (float)((double)yaw + rotationVertical);
                    if (newPitch > 90.0f) {
                        newPitch = 90.0f;
                    }
                    if (newPitch < -90.0f && rotationVertical != 0.0) {
                        newPitch += 90.0f;
                        newPitch *= -1.0f;
                        newPitch = -90.0f + newPitch;
                        newYaw = newYaw > 0.0f ? -180.0f + newYaw : (newYaw < 0.0f ? 180.0f + newYaw : 0.0f);
                    }
                    loc.setPitch(newPitch);
                    loc.setYaw(newYaw);
                    if (sCommandToExec.getActionInfo().getVelocity().isPresent()) {
                        eyeVector = sCommandToExec.getActionInfo().getVelocity().get();
                        double oldVelocity = eyeVector.length();
                        Location customLoc = eyeVector.toLocation(receiver.getWorld());
                        customLoc.setPitch(newPitch);
                        customLoc.setYaw(newYaw);
                        eyeVector = customLoc.getDirection();
                        eyeVector = eyeVector.multiply(oldVelocity);
                    } else {
                        eyeVector = loc.getDirection();
                    }
                    eyeVector = eyeVector.multiply(velocity);
                    if (!SCore.is1v13Less()) {
                        if (entity instanceof Fireball) {
                            Fireball fireball = (Fireball)entity;
                            fireball.setDirection(eyeVector);
                        } else if (entity instanceof DragonFireball) {
                            DragonFireball fireball = (DragonFireball)entity;
                            fireball.setDirection(eyeVector);
                        } else {
                            entity.setVelocity(eyeVector);
                        }
                    }
                }
                if (projectile != null) {
                    Material mat = ((SProjectileType)((Object)((Optional)projectile.getType().getValue()).get())).getMaterial();
                    if (entity instanceof ThrownPotion) {
                        ThrownPotion lp = (ThrownPotion)entity;
                        ItemStack item = new ItemStack(mat, 1);
                        PotionMeta pMeta = (PotionMeta)item.getItemMeta();
                        pMeta.setColor(Color.AQUA);
                        item.setItemMeta((ItemMeta)pMeta);
                        lp.setItem(item);
                    }
                    projectile.transformTheProjectile((Entity)entity, receiver, mat);
                }
                if (SCore.hasExecutableItems) {
                    ProjectileInfo pInfo = new ProjectileInfo(receiver, entity.getUniqueId(), Optional.ofNullable(sCommandToExec.getActionInfo().getExecutableItem()), sCommandToExec.getActionInfo().getSlot().intValue(), System.currentTimeMillis());
                    ProjectilesHandler.getInstance().addProjectileInfo(pInfo);
                }
                PlayerCustomLaunchEntityEvent playerCustomLaunchProjectileEvent = new PlayerCustomLaunchEntityEvent(receiver, (Entity)entity);
                Bukkit.getServer().getPluginManager().callEvent((Event)playerCustomLaunchProjectileEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("LAUNCH");
        return names;
    }

    @Override
    public String getTemplate() {
        return "LAUNCH projectile:ARROW angleRotationVertical:0 angleRotationHorizontal:0 velocity:1";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

