/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.executableitems.listeners.projectiles.ProjectileInfo;
import com.ssomar.executableitems.listeners.projectiles.ProjectilesHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.events.PlayerCustomLaunchEntityEvent;
import com.ssomar.score.projectiles.SProjectile;
import com.ssomar.score.projectiles.SProjectileType;
import com.ssomar.score.projectiles.manager.SProjectilesManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class LocatedLaunch
extends PlayerCommand {
    public LocatedLaunch() {
        CommandSetting projectileType = new CommandSetting("projectile", 0, String.class, null);
        CommandSetting frontValue = new CommandSetting("frontValue", 1, Double.class, (Object)0.0);
        CommandSetting rightValue = new CommandSetting("rightValue", 2, Double.class, (Object)0.0);
        CommandSetting yValue = new CommandSetting("yValue", 3, Double.class, (Object)0.0);
        CommandSetting velocity = new CommandSetting("velocity", 4, Double.class, (Object)1.0);
        CommandSetting angleRotationVertical = new CommandSetting("angleRotationVertical", 5, Double.class, (Object)0.0);
        CommandSetting angleRotationHorizontal = new CommandSetting("angleRotationHorizontal", 6, Double.class, (Object)0.0);
        List<CommandSetting> settings = this.getSettings();
        settings.add(projectileType);
        settings.add(frontValue);
        settings.add(rightValue);
        settings.add(yValue);
        settings.add(velocity);
        settings.add(angleRotationVertical);
        settings.add(angleRotationHorizontal);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        double frontValue = (Double)sCommandToExec.getSettingValue("frontValue");
        double rightValue = (Double)sCommandToExec.getSettingValue("rightValue");
        double yValue = (Double)sCommandToExec.getSettingValue("yValue");
        double velocity = (Double)sCommandToExec.getSettingValue("velocity");
        double rotationVertical = (Double)sCommandToExec.getSettingValue("angleRotationVertical");
        double rotationHorizontal = (Double)sCommandToExec.getSettingValue("angleRotationHorizontal");
        Location eyeLoc = receiver.getEyeLocation();
        Vector eyeDir = eyeLoc.getDirection();
        Vector front = eyeDir.clone().multiply(frontValue);
        Vector right = new Vector(0, 1, 0).crossProduct(eyeDir).normalize().multiply(rightValue);
        Vector calcul = front.add(right);
        Location recLoc = receiver.getLocation();
        double newX = recLoc.getX() + calcul.getX();
        double newY = recLoc.getY() + calcul.getY();
        double newZ = recLoc.getZ() + calcul.getZ();
        Location toLaunchLoc = new Location(recLoc.getWorld(), newX, newY, newZ);
        toLaunchLoc.add(0.0, yValue, 0.0);
        Projectile entity = null;
        String type = (String)sCommandToExec.getSettingValue("projectile");
        Optional projectileOptional = null;
        SProjectile projectile = null;
        if (SProjectileType.getProjectilesClasses().containsKey(type)) {
            entity = (Projectile)recLoc.getWorld().spawn(toLaunchLoc, SProjectileType.getProjectilesClasses().get(type));
            entity.setVelocity(eyeLoc.getDirection());
        } else {
            projectileOptional = SProjectilesManager.getInstance().getLoadedObjectWithID(type);
            if (projectileOptional.isPresent()) {
                projectile = (SProjectile)projectileOptional.get();
                entity = (Projectile)recLoc.getWorld().spawn(toLaunchLoc, SProjectileType.getProjectilesClasses().get(((SProjectileType)((Object)((Optional)projectile.getType().getValue()).get())).getValidNames()[0]));
                projectile.transformTheProjectile((Entity)entity, receiver, ((SProjectileType)((Object)((Optional)projectile.getType().getValue()).get())).getMaterial());
            } else {
                entity = (Projectile)recLoc.getWorld().spawn(toLaunchLoc, Arrow.class);
            }
        }
        entity.setShooter((ProjectileSource)receiver);
        Vector vector = entity.getVelocity().rotateAroundAxis(entity.getVelocity().getCrossProduct(new Vector(0, 1, 0)), rotationVertical * Math.PI / 180.0);
        vector = vector.rotateAroundAxis(this.getPlayerHeadVector(receiver), rotationHorizontal * Math.PI / 180.0);
        if (Double.isNaN(vector.getX())) {
            vector.setX(0);
        }
        if (Double.isNaN(vector.getY())) {
            vector.setY(0);
        }
        if (Double.isNaN(vector.getZ())) {
            vector.setZ(0);
        }
        entity.setVelocity(vector);
        entity.setVelocity(entity.getVelocity().multiply(velocity));
        if (SCore.hasExecutableItems && aInfo.getExecutableItem() != null) {
            ProjectileInfo pInfo = new ProjectileInfo(receiver, entity.getUniqueId(), Optional.ofNullable(aInfo.getExecutableItem()), aInfo.getSlot().intValue(), System.currentTimeMillis());
            ProjectilesHandler.getInstance().addProjectileInfo(pInfo);
        }
        PlayerCustomLaunchEntityEvent playerCustomLaunchProjectileEvent = new PlayerCustomLaunchEntityEvent(receiver, (Entity)entity);
        Bukkit.getServer().getPluginManager().callEvent((Event)playerCustomLaunchProjectileEvent);
    }

    public Vector getPlayerHeadVector(Player player) {
        Vector lookDirection = player.getEyeLocation().getDirection();
        Vector right = lookDirection.getCrossProduct(new Vector(0, 1, 0)).normalize();
        Vector up = right.getCrossProduct(lookDirection).normalize();
        return up.multiply(0.4);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("LOCATED_LAUNCH");
        return names;
    }

    @Override
    public String getTemplate() {
        return "LOCATED_LAUNCH projectile:ARROW frontValue:0 rightValue:0 yValue:0 velocity:1 angleRotationVertical:0 angleRotationHorizontal:0";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

