/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ModifyDurability
extends PlayerCommand {
    public ModifyDurability() {
        CommandSetting modification = new CommandSetting("modification", 0, Integer.class, (Object)50);
        CommandSetting slot = new CommandSetting("slot", 1, Integer.class, (Object)-1);
        CommandSetting supportUnbreaking = new CommandSetting("supportUnbreaking", 2, Boolean.class, (Object)false);
        List<CommandSetting> settings = this.getSettings();
        settings.add(modification);
        settings.add(slot);
        settings.add(supportUnbreaking);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        ItemStack item;
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        int modification = (Integer)sCommandToExec.getSettingValue("modification");
        boolean supportUnbreaking = (Boolean)sCommandToExec.getSettingValue("supportUnbreaking");
        PlayerInventory pInv = receiver.getInventory();
        if (slot == -1) {
            slot = pInv.getHeldItemSlot();
        }
        if ((item = pInv.getItem(slot)) == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        if (item.getItemMeta() instanceof Damageable) {
            Enchantment unbreaking;
            Damageable meta = (Damageable)item.getItemMeta();
            Map enchants = item.getEnchantments();
            int unbreakingLevel = 0;
            Enchantment enchantment = unbreaking = SCore.is1v20v5Plus() ? Enchantment.UNBREAKING : Enchantment.getByName((String)"DURABILITY");
            if (supportUnbreaking && enchants.containsKey(unbreaking)) {
                unbreakingLevel = (Integer)enchants.get(unbreaking);
            }
            int maxDura = item.getType().getMaxDurability();
            if (SCore.is1v21Plus() && meta.hasMaxDamage()) {
                maxDura = meta.getMaxDamage();
            }
            if (modification < 0) {
                for (int i = modification; i < 0; ++i) {
                    int random = (int)(Math.random() * 100.0);
                    if (random <= 100 / (unbreakingLevel + 1)) continue;
                    ++modification;
                }
                meta.setDamage(meta.getDamage() - modification);
                if (meta.getDamage() >= maxDura) {
                    item.setAmount(item.getAmount() - 1);
                    return;
                }
                item.setItemMeta((ItemMeta)meta);
            } else {
                int newDamage = meta.getDamage() - modification;
                if (newDamage < 0) {
                    newDamage = 0;
                }
                meta.setDamage(newDamage);
                item.setItemMeta((ItemMeta)meta);
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("MODIFY_DURABILITY");
        names.add("MODIFYDURABILITY");
        return names;
    }

    @Override
    public String getTemplate() {
        return "MODIFY_DURABILITY modification:50 slot:-1 supportUnbreaking:false";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

