/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.commands.settempblock.SetTempBlockManager;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.features.types.list.ListDetailedMaterialFeature;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.safeplace.SafePlace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.Player;

public class SetTempBlockPos
extends PlayerCommand {
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public SetTempBlockPos() {
        CommandSetting x = new CommandSetting("x", 0, Double.class, (Object)0.0);
        CommandSetting y = new CommandSetting("y", 1, Double.class, (Object)0.0);
        CommandSetting z = new CommandSetting("z", 2, Double.class, (Object)0.0);
        CommandSetting world = new CommandSetting("world", -1, String.class, (Object)"");
        CommandSetting material = new CommandSetting("material", 3, Material.class, (Object)Material.STONE);
        CommandSetting time = new CommandSetting("time", 4, Integer.class, (Object)10);
        CommandSetting bypassProtection = new CommandSetting("bypassProtection", 5, Boolean.class, (Object)false);
        CommandSetting whitelistCurrentBlock = new CommandSetting("whitelistCurrentBlock", 6, String.class, (Object)"");
        List<CommandSetting> settings = this.getSettings();
        settings.add(x);
        settings.add(y);
        settings.add(z);
        settings.add(world);
        settings.add(material);
        settings.add(time);
        settings.add(bypassProtection);
        settings.add(whitelistCurrentBlock);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        double x = (Double)sCommandToExec.getSettingValue("x");
        double y = (Double)sCommandToExec.getSettingValue("y");
        double z = (Double)sCommandToExec.getSettingValue("z");
        String world = (String)sCommandToExec.getSettingValue("world");
        Material material = (Material)sCommandToExec.getSettingValue("material");
        int time = (Integer)sCommandToExec.getSettingValue("time");
        boolean bypassProtection = (Boolean)sCommandToExec.getSettingValue("bypassProtection");
        String whitelistCurrentBlock = (String)sCommandToExec.getSettingValue("whitelistCurrentBlock");
        World w = receiver.getWorld();
        if (!world.isEmpty()) {
            w = SCore.plugin.getServer().getWorld(world);
        }
        Location blockLoc = new Location(w, x, y, z);
        Block block = blockLoc.getBlock();
        BlockData data = block.getBlockData().clone();
        ListDetailedMaterialFeature listDetailedMaterialFeature = new ListDetailedMaterialFeature(true);
        if (!whitelistCurrentBlock.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            if (whitelistCurrentBlock.contains(",")) {
                list = Arrays.asList(whitelistCurrentBlock.split(","));
            } else {
                list.add(whitelistCurrentBlock);
            }
            listDetailedMaterialFeature.load((SPlugin)SCore.plugin, list, true);
        }
        UUID uuid = receiver.getUniqueId();
        SsomarDev.testMsg("DEBUG place 0", true);
        if (data instanceof Bisected || data instanceof Orientable || data instanceof Rotatable || data instanceof Slab || data instanceof Directional || this.verifDependentBlock(block)) {
            return;
        }
        if (!listDetailedMaterialFeature.verifBlock(block)) {
            return;
        }
        SsomarDev.testMsg("DEBUG PLACE 1", true);
        SafePlace.placeBlockWithEvent(block, material, Optional.empty(), uuid, false, !bypassProtection);
        SetTempBlockManager.getInstance().runInitTempBlock(block.getLocation(), data, time);
    }

    public boolean verifDependentBlock(Block block) {
        for (BlockFace blockFace : BLOCK_FACES) {
            Block relative = block.getRelative(blockFace);
            Material mat = relative.getType();
            if (mat != Material.TORCH && mat != Material.LADDER) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_TEMP_BLOCK_POS");
        names.add("SETTEMPBLOCKPOS");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_TEMP_BLOCK_POS x:0.0 y:0.0 z:0.0 material:STONE time:10 bypassProtection:true whitelistCurrentBlock:SAND,DIRT";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

