/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.score;

import com.ssomar.score.commands.score.CustomCommandWithManagerAbstract;
import com.ssomar.score.commands.score.GiveCommand;
import com.ssomar.score.sobject.SObjectWithFile;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.strings.StringSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GiveFolderCommand<X extends SPlugin, Y extends SObjectWithFileManager<Z>, Z extends SObjectWithFile>
extends CustomCommandWithManagerAbstract<X, Y, Z> {
    public GiveFolderCommand(X sPlugin, Y sObjectManager) {
        super(sPlugin, sObjectManager);
    }

    public void giveFolder(CommandSender sender, String folder, String amount, String player, Map<String, Object> settings, String world, boolean giveOfflinePlayer, String commandToRunIfPlayerIsOffline) {
        List<Z> objectOpt = this.checkFolder(sender, folder);
        Optional<Integer> amountOpt = this.checkAmount(sender, amount);
        if (!amountOpt.isPresent()) {
            return;
        }
        Optional<Optional<Player>> playerOpt = this.checkPlayer(sender, player, giveOfflinePlayer);
        Optional<Optional<World>> worldOpt = this.checkWorld(sender, world);
        if (objectOpt.size() == 0 || !worldOpt.isPresent()) {
            return;
        }
        if (!playerOpt.isPresent()) {
            GiveCommand.runOfflineCommand(player, giveOfflinePlayer, commandToRunIfPlayerIsOffline);
            return;
        }
        for (SObjectWithFile eI : objectOpt) {
            new GiveCommand(this.getSPlugin(), (SObjectWithFileManager)this.getSObjectManager()).give(playerOpt.get(), eI, amountOpt.get(), settings, worldOpt.get());
        }
        this.getSm().sendMessage(sender, this.getSPlugin().getNameDesign() + " &aFolder: &e" + folder + " &agiven to &e" + player);
    }

    public List<Z> checkFolder(CommandSender sender, String folder) {
        List oOpt = ((SObjectWithFileManager)this.getSObjectManager()).getObjectsOfFolder(folder);
        if (oOpt.size() == 0) {
            this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameDesignWithBrackets() + " Folder " + folder + " not found or empty");
        }
        return oOpt;
    }

    @Override
    public void run(CommandSender sender, String command, String[] args, String typedCommand) {
        switch (command) {
            case "givefolder": {
                if (args.length >= 2) {
                    ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                    Map<String, Object> settings = StringSetting.extractSettingsAndRebuildCorrectly(arguments, 1, new ArrayList<String>());
                    String pName = (String)arguments.get(0);
                    String eiID = (String)arguments.get(1);
                    String quantity = "1";
                    if (arguments.size() >= 3) {
                        quantity = (String)arguments.get(2);
                    }
                    boolean giveOfflinePlayer = true;
                    if (arguments.size() >= 4) {
                        giveOfflinePlayer = Boolean.parseBoolean((String)arguments.get(3));
                    }
                    new GiveFolderCommand(this.getSPlugin(), (SObjectWithFileManager)this.getSObjectManager()).giveFolder(sender, eiID, quantity, pName, settings, "", giveOfflinePlayer, typedCommand);
                    break;
                }
                this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cNot enough args &6/" + this.getSPlugin().getShortName().toLowerCase() + " givefolder {playername} {folder} {quantity} [giveOfflinePlayer]");
            }
        }
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("givefolder");
        return commands;
    }

    @Override
    public List<String> getArguments(String command, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        switch (args[0]) {
            case "givefolder": {
                if (args.length == 3) {
                    return ((SObjectWithFileManager)this.getSObjectManager()).getFoldersNames();
                }
                if (args.length != 4) break;
                arguments.add("0");
                arguments.add("1");
                arguments.add("3");
                arguments.add("5");
                arguments.add("10");
                arguments.add("25");
                arguments.add("50");
                return arguments;
            }
        }
        return arguments;
    }

    @Override
    public Optional<Integer> checkAmount(CommandSender sender, String amount) {
        if (!NTools.getInteger(amount).isPresent()) {
            this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " Invalid amount : " + amount);
            return Optional.empty();
        }
        if (NTools.getInteger(amount).get() > this.getSPlugin().getPluginConfig().getIntSetting("giveLimit", 100)) {
            this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " Quantity > " + this.getSPlugin().getPluginConfig().getIntSetting("giveLimit", 100) + " is blocked for security !");
            return Optional.empty();
        }
        return NTools.getInteger(amount);
    }
}

