/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.events;

import com.ssomar.score.config.GeneralConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;

public class CheckIfDamageIsPosssibleListener
implements Listener {
    private static CheckIfDamageIsPosssibleListener instance;
    private Map<UUID, Boolean> canDamage = new HashMap<UUID, Boolean>();
    private List<UUID> damageList = new ArrayList<UUID>();

    public static CheckIfDamageIsPosssibleListener getInstance() {
        if (instance == null) {
            instance = new CheckIfDamageIsPosssibleListener();
        }
        return instance;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void checkIfDamageEventCancelled(EntityDamageByEntityEvent e) {
        Entity damager = e.getDamager();
        if (e.getDamage() == 0.0) {
            this.canDamage.put(damager.getUniqueId(), !e.isCancelled());
            if (this.damageList.contains(damager.getUniqueId())) {
                e.setCancelled(true);
                this.damageList.remove(damager.getUniqueId());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void checkIfDamageEventCancelled2(EntityDamageByEntityEvent e) {
        if (!GeneralConfig.getInstance().isDebugCheckDamages()) {
            return;
        }
        if (e.getDamage() == 0.0) {
            RegisteredListener[] registeredListener;
            for (RegisteredListener rl : registeredListener = e.getHandlers().getRegisteredListeners()) {
                if (rl.getListener() == this) continue;
                try {
                    rl.callEvent((Event)e);
                }
                catch (EventException ex) {
                    throw new RuntimeException(ex);
                }
                if (e.isCancelled()) break;
            }
        }
    }

    public boolean canDamage(@NotNull Entity damager, @NotNull Damageable damaged) {
        this.damageList.add(damager.getUniqueId());
        damaged.damage(0.0, damager);
        return this.canDamage.getOrDefault(damager.getUniqueId(), true);
    }
}

