/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.armortrim;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.TrimMaterialFeature;
import com.ssomar.score.features.types.TrimPatternFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public class ArmorTrim
extends FeatureWithHisOwnEditor<ArmorTrim, ArmorTrim, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature enableArmorTrim;
    private TrimMaterialFeature trimMaterial;
    private TrimPatternFeature pattern;

    public ArmorTrim(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.armorTrim);
        this.reset();
    }

    @Override
    public void reset() {
        this.enableArmorTrim = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.enableArmorTrim);
        if (SCore.is1v20Plus()) {
            this.trimMaterial = new TrimMaterialFeature(this.getParent(), Optional.of(TrimMaterial.DIAMOND), FeatureSettingsSCore.trimMaterial);
            this.pattern = new TrimPatternFeature(this.getParent(), Optional.of(TrimPattern.EYE), FeatureSettingsSCore.pattern);
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            this.enableArmorTrim.load(plugin, section, isPremiumLoading);
            this.trimMaterial.load(plugin, section, isPremiumLoading);
            this.pattern.load(plugin, section, isPremiumLoading);
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enableArmorTrim.save(section);
        this.trimMaterial.save(section);
        this.pattern.save(section);
    }

    @Override
    public ArmorTrim getValue() {
        return this;
    }

    public org.bukkit.inventory.meta.trim.ArmorTrim getArmorTrim() {
        if (!((Optional)this.getTrimMaterial().getValue()).isPresent() || !((Optional)this.getPattern().getValue()).isPresent()) {
            return null;
        }
        org.bukkit.inventory.meta.trim.ArmorTrim armorTrim = new org.bukkit.inventory.meta.trim.ArmorTrim((TrimMaterial)((Optional)this.getTrimMaterial().getValue()).get(), (TrimPattern)((Optional)this.getPattern().getValue()).get());
        return armorTrim;
    }

    @Override
    public ArmorTrim initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = this.enableArmorTrim.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Enabled: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = "&7TrimMaterial: &e" + this.trimMaterial.getStringValue(((Optional)this.trimMaterial.getValue()).orElse(TrimMaterial.DIAMOND));
        finalDescription[finalDescription.length - 1] = "&7TrimPattern: &e" + this.pattern.getStringValue(((Optional)this.pattern.getValue()).orElse(TrimPattern.EYE));
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ArmorTrim clone(FeatureParentInterface newParent) {
        ArmorTrim dropFeatures = new ArmorTrim(newParent);
        dropFeatures.enableArmorTrim = this.enableArmorTrim.clone(dropFeatures);
        if (SCore.is1v20Plus()) {
            dropFeatures.trimMaterial = this.trimMaterial.clone(dropFeatures);
            dropFeatures.pattern = this.pattern.clone(dropFeatures);
        }
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enableArmorTrim);
        features.add(this.trimMaterial);
        features.add(this.pattern);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ArmorTrim)) continue;
            ArmorTrim hiders = (ArmorTrim)feature;
            hiders.setEnableArmorTrim(this.enableArmorTrim);
            hiders.setTrimMaterial(this.trimMaterial);
            hiders.setPattern(this.pattern);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20Plus();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof ArmorMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        ArmorMeta meta;
        if (this.isAvailable() && this.isApplicable(args) && (meta = (ArmorMeta)args.getMeta()) != null && this.enableArmorTrim.getValue().booleanValue()) {
            meta.setTrim(this.getArmorTrim());
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ArmorMeta meta;
        if (this.isAvailable() && this.isApplicable(args) && (meta = (ArmorMeta)args.getMeta()) != null && meta.hasTrim()) {
            this.enableArmorTrim.setValue(true);
            this.trimMaterial.setValue(Optional.of(meta.getTrim().getMaterial()));
            this.pattern.setValue(Optional.of(meta.getTrim().getPattern().getKey().toString()));
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.ARMOR_SETTINGS;
    }

    @Generated
    public BooleanFeature getEnableArmorTrim() {
        return this.enableArmorTrim;
    }

    @Generated
    public TrimMaterialFeature getTrimMaterial() {
        return this.trimMaterial;
    }

    @Generated
    public TrimPatternFeature getPattern() {
        return this.pattern;
    }

    @Generated
    public void setEnableArmorTrim(BooleanFeature enableArmorTrim) {
        this.enableArmorTrim = enableArmorTrim;
    }

    @Generated
    public void setTrimMaterial(TrimMaterialFeature trimMaterial) {
        this.trimMaterial = trimMaterial;
    }

    @Generated
    public void setPattern(TrimPatternFeature pattern) {
        this.pattern = pattern;
    }
}

