/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.blocktitle;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.list.ListColoredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import eu.decentsoftware.holograms.api.DHAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockTitleFeatures
extends FeatureWithHisOwnEditor<BlockTitleFeatures, BlockTitleFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private ListColoredStringFeature title;
    private DoubleFeature titleAjustement;
    private BooleanFeature activeTitle;

    public BlockTitleFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.titleFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.activeTitle = new BooleanFeature(this, false, FeatureSettingsSCore.activeTitle);
        this.title = new ListColoredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.title, Optional.empty());
        this.titleAjustement = new DoubleFeature(this, Optional.of(0.5), FeatureSettingsSCore.titleAdjustment);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            error.addAll(this.activeTitle.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
            error.addAll(this.title.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
            error.addAll(this.titleAjustement.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.activeTitle.save(section);
        this.title.save(section);
        this.titleAjustement.save(section);
    }

    @Override
    public BlockTitleFeatures getValue() {
        return this;
    }

    @Override
    public BlockTitleFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = this.activeTitle.getValue() != false ? "&7Active title: &a&l\u2714" : "&7Active title: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = "&7Title lines: &e&l" + this.title.getValues().size();
        finalDescription[finalDescription.length - 1] = "&7Title Ajustement: &e" + ((Optional)this.titleAjustement.getValue()).get();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public BlockTitleFeatures clone(FeatureParentInterface newParent) {
        BlockTitleFeatures dropFeatures = new BlockTitleFeatures(newParent);
        dropFeatures.setActiveTitle(this.activeTitle.clone(dropFeatures));
        dropFeatures.setTitle(this.title.clone(dropFeatures));
        dropFeatures.setTitleAjustement(this.titleAjustement.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.activeTitle);
        features.add(this.title);
        features.add(this.titleAjustement);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BlockTitleFeatures)) continue;
            BlockTitleFeatures dropFeatures = (BlockTitleFeatures)feature;
            dropFeatures.setActiveTitle(this.activeTitle);
            dropFeatures.setTitle(this.title);
            dropFeatures.setTitleAjustement(this.titleAjustement);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public String getSimpleLocString(Location loc) {
        return loc.getWorld().getName() + "-" + loc.getBlockX() + "-" + loc.getBlockY() + "-" + loc.getBlockZ();
    }

    public Location spawn(@NotNull Location location, StringPlaceholder sp) {
        Location loc;
        CMIHologram holo;
        if (!this.activeTitle.getValue().booleanValue()) {
            return null;
        }
        String pluginToUse = GeneralConfig.getInstance().getHologramsPlugin().toUpperCase();
        List<String> lines = new ArrayList<String>();
        for (String s : this.getTitle().getValues()) {
            s = StringConverter.coloredString(s);
            lines.add(s);
        }
        final List<String> finalLines = lines = sp.replacePlaceholders(lines);
        if (SCore.hasCMI && (!SCore.is1v20v4Plus() || pluginToUse.equals("CMI"))) {
            holo = new CMIHologram(UUID.randomUUID().toString(), location.clone().add(0.0, 0.5 + (Double)((Optional)this.getTitleAjustement().getValue()).get(), 0.0));
            holo.setLines(lines);
            CMI.getInstance().getHologramManager().addHologram(holo);
            holo.update();
            return holo.getLocation().getBukkitLoc();
        }
        if (SCore.hasDecentHolograms && (!SCore.is1v20v4Plus() || pluginToUse.equals("DECENT_HOLOGRAMS"))) {
            loc = location.clone().add(0.0, 0.5 + (Double)((Optional)this.getTitleAjustement().getValue()).get(), 0.0);
            if (DHAPI.getHologram((String)this.getSimpleLocString(loc)) != null) {
                this.remove(loc);
            }
            DHAPI.createHologram((String)this.getSimpleLocString(loc), (Location)loc, lines);
            Runnable runnable = new Runnable(){
                final /* synthetic */ BlockTitleFeatures this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (DHAPI.getHologram((String)loc.toString()) != null) {
                        this.this$0.remove(loc);
                        eu.decentsoftware.holograms.api.holograms.Hologram hologram = DHAPI.createHologram((String)this.this$0.getSimpleLocString(loc), (Location)loc, (List)finalLines);
                        hologram.updateAll();
                    }
                }
            };
            SCore.schedulerHook.runLocationTask(runnable, loc, 1L);
            return loc;
        }
        if (SCore.hasHolographicDisplays && (!SCore.is1v20v4Plus() || pluginToUse.equals("HOLOGRAPHIC_DISPLAYS"))) {
            holo = HolographicDisplaysAPI.get((Plugin)SCore.plugin).createHologram(location.clone().add(0.0, 0.5 + (Double)((Optional)this.getTitleAjustement().getValue()).get(), 0.0));
            for (String s : lines) {
                if (s.contains("ITEM::")) {
                    Material material = Material.STONE;
                    try {
                        material = Material.valueOf((String)s.split("ITEM::")[1].trim().toUpperCase());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    holo.getLines().appendItem(new ItemStack(material));
                    continue;
                }
                holo.getLines().appendText(s);
            }
            return holo.getPosition().toLocation();
        }
        if (SCore.is1v20v4Plus()) {
            loc = location.clone().add(0.0, 0.5 + (Double)((Optional)this.getTitleAjustement().getValue()).get(), 0.0);
            loc.setYaw(0.0f);
            TextDisplay textDisplay = (TextDisplay)loc.getWorld().spawn(loc, TextDisplay.class);
            textDisplay.setSeeThrough(true);
            textDisplay.setBillboard(Display.Billboard.CENTER);
            textDisplay.setViewRange(25.0f);
            StringBuilder sb = new StringBuilder();
            for (String s : lines) {
                sb.append(s).append("\n");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            textDisplay.setText(sb.toString());
            return loc;
        }
        return null;
    }

    public void remove(@NotNull Location location) {
        block6: {
            String pluginToUse;
            block7: {
                block5: {
                    pluginToUse = GeneralConfig.getInstance().getHologramsPlugin().toUpperCase();
                    if (!SCore.hasCMI || SCore.is1v20v4Plus() && !pluginToUse.equals("CMI")) break block5;
                    CMIHologram holo = CMI.getInstance().getHologramManager().getByLoc(location);
                    if (holo == null) break block6;
                    holo.remove();
                    break block6;
                }
                if (!SCore.hasDecentHolograms || SCore.is1v20v4Plus() && !pluginToUse.equals("DECENT_HOLOGRAMS")) break block7;
                eu.decentsoftware.holograms.api.holograms.Hologram hologram = DHAPI.getHologram((String)this.getSimpleLocString(location));
                if (hologram == null) break block6;
                hologram.destroy();
                break block6;
            }
            if (SCore.hasHolographicDisplays && (!SCore.is1v20v4Plus() || pluginToUse.equals("HOLOGRAPHIC_DISPLAYS"))) {
                for (Hologram holo : HolographicDisplaysAPI.get((Plugin)SCore.plugin).getHolograms()) {
                    if (!holo.getPosition().toLocation().equals((Object)location)) continue;
                    holo.delete();
                }
            } else if (SCore.is1v20v4Plus()) {
                for (TextDisplay textDisplay : location.getWorld().getEntitiesByClass(TextDisplay.class)) {
                    if (!textDisplay.getLocation().equals((Object)location)) continue;
                    textDisplay.remove();
                }
            }
        }
    }

    public Location update(@Nullable Location location, @NotNull Location objectLocation, StringPlaceholder sp) {
        if (!objectLocation.isWorldLoaded() || !objectLocation.isChunkLoaded()) {
            return location;
        }
        String pluginToUse = GeneralConfig.getInstance().getHologramsPlugin().toUpperCase();
        if (!this.activeTitle.getValue().booleanValue()) {
            if (location != null) {
                this.remove(location);
            }
            return null;
        }
        if (location == null) {
            return this.spawn(objectLocation, sp);
        }
        List<String> lines = new ArrayList<String>();
        for (String s : this.getTitle().getValues()) {
            s = StringConverter.coloredString(s);
            lines.add(s);
        }
        lines = sp.replacePlaceholders(lines);
        if (SCore.hasCMI && (!SCore.is1v20v4Plus() || pluginToUse.equals("CMI"))) {
            CMIHologram holo = CMI.getInstance().getHologramManager().getByLoc(location);
            if (holo != null) {
                holo.setLines(lines);
                holo.update();
                return location;
            }
            return this.spawn(objectLocation, sp);
        }
        if (SCore.hasDecentHolograms && (!SCore.is1v20v4Plus() || pluginToUse.equals("DECENT_HOLOGRAMS"))) {
            eu.decentsoftware.holograms.api.holograms.Hologram hologram = DHAPI.getHologram((String)location.toString());
            if (hologram != null) {
                DHAPI.setHologramLines((eu.decentsoftware.holograms.api.holograms.Hologram)hologram, lines);
                return location;
            }
            return this.spawn(objectLocation, sp);
        }
        if (SCore.hasHolographicDisplays && (!SCore.is1v20v4Plus() || pluginToUse.equals("HOLOGRAPHIC_DISPLAYS"))) {
            this.remove(location);
            return this.spawn(objectLocation, sp);
        }
        if (SCore.is1v20v4Plus()) {
            this.remove(location);
            return this.spawn(objectLocation, sp);
        }
        return location;
    }

    @Generated
    public ListColoredStringFeature getTitle() {
        return this.title;
    }

    @Generated
    public DoubleFeature getTitleAjustement() {
        return this.titleAjustement;
    }

    @Generated
    public BooleanFeature getActiveTitle() {
        return this.activeTitle;
    }

    @Generated
    public void setTitle(ListColoredStringFeature title) {
        this.title = title;
    }

    @Generated
    public void setTitleAjustement(DoubleFeature titleAjustement) {
        this.titleAjustement = titleAjustement;
    }

    @Generated
    public void setActiveTitle(BooleanFeature activeTitle) {
        this.activeTitle = activeTitle;
    }
}

