/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.block.parent;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.block.BlockConditionFeature;
import com.ssomar.score.features.custom.conditions.block.BlockConditionRequest;
import com.ssomar.score.features.custom.conditions.block.condition.AroundBlockConditions;
import com.ssomar.score.features.custom.conditions.block.condition.IfBlockAge;
import com.ssomar.score.features.custom.conditions.block.condition.IfBlockLocationX;
import com.ssomar.score.features.custom.conditions.block.condition.IfBlockLocationY;
import com.ssomar.score.features.custom.conditions.block.condition.IfBlockLocationZ;
import com.ssomar.score.features.custom.conditions.block.condition.IfContainerContains;
import com.ssomar.score.features.custom.conditions.block.condition.IfContainerContainsEI;
import com.ssomar.score.features.custom.conditions.block.condition.IfContainerContainsSellableItem;
import com.ssomar.score.features.custom.conditions.block.condition.IfContainerEmpty;
import com.ssomar.score.features.custom.conditions.block.condition.IfContainerNotEmpty;
import com.ssomar.score.features.custom.conditions.block.condition.IfIsPowered;
import com.ssomar.score.features.custom.conditions.block.condition.IfMustBeEB;
import com.ssomar.score.features.custom.conditions.block.condition.IfMustBeNatural;
import com.ssomar.score.features.custom.conditions.block.condition.IfMustBeNotNatural;
import com.ssomar.score.features.custom.conditions.block.condition.IfMustBeNotPowered;
import com.ssomar.score.features.custom.conditions.block.condition.IfNoPlayerMustBeOnTheBlock;
import com.ssomar.score.features.custom.conditions.block.condition.IfPlantFullyGrown;
import com.ssomar.score.features.custom.conditions.block.condition.IfPlantNotFullyGrown;
import com.ssomar.score.features.custom.conditions.block.condition.IfPlayerMustBeOnTheBlock;
import com.ssomar.score.features.custom.conditions.block.condition.IfUsage;
import com.ssomar.score.features.custom.conditions.block.parent.BlockConditionsFeatureEditor;
import com.ssomar.score.features.custom.conditions.block.parent.BlockConditionsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockConditionsFeature
extends FeatureWithHisOwnEditor<BlockConditionsFeature, BlockConditionsFeature, BlockConditionsFeatureEditor, BlockConditionsFeatureEditorManager> {
    private List<BlockConditionFeature> conditions;

    public BlockConditionsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    @Override
    public void reset() {
        this.conditions = new ArrayList<BlockConditionFeature>();
        this.conditions.add(new IfIsPowered(this));
        this.conditions.add(new IfMustBeNotPowered(this));
        this.conditions.add(new IfMustBeNatural(this));
        this.conditions.add(new IfMustBeNotNatural(this));
        this.conditions.add(new IfMustBeEB(this));
        this.conditions.add(new IfPlayerMustBeOnTheBlock(this));
        this.conditions.add(new IfNoPlayerMustBeOnTheBlock(this));
        if (!SCore.is1v12Less()) {
            this.conditions.add(new IfPlantFullyGrown(this));
            this.conditions.add(new IfPlantNotFullyGrown(this));
        }
        if (!SCore.is1v11Less()) {
            this.conditions.add(new IfContainerEmpty(this));
            this.conditions.add(new IfContainerNotEmpty(this));
            this.conditions.add(new IfContainerContains(this));
            this.conditions.add(new IfContainerContainsEI(this));
            this.conditions.add(new IfContainerContainsSellableItem(this));
        }
        if (!SCore.is1v12Less()) {
            this.conditions.add(new IfBlockAge(this));
        }
        this.conditions.add(new IfBlockLocationX(this));
        this.conditions.add(new IfBlockLocationY(this));
        this.conditions.add(new IfBlockLocationZ(this));
        this.conditions.add(new IfUsage(this));
        this.conditions.add(new AroundBlockConditions(this));
    }

    public boolean verifConditions(Block block, Optional<Player> playerOpt, SendMessage messageSender, @Nullable Event event) {
        BlockConditionRequest request = new BlockConditionRequest(block, playerOpt, messageSender.getSp(), event);
        for (BlockConditionFeature condition : this.conditions) {
            if (condition.verifCondition(request)) continue;
            if (playerOpt.isPresent()) {
                for (String error : request.getErrorsFinal()) {
                    messageSender.sendMessage(playerOpt.get(), error);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (BlockConditionFeature condition : this.conditions) {
                error.addAll(condition.load(plugin, section, isPremiumLoading));
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (BlockConditionFeature condition : this.conditions) {
            condition.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public BlockConditionsFeature getValue() {
        return this;
    }

    @Override
    public BlockConditionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7Block condition(s) enabled: &e" + this.getBlockConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public int getBlockConditionEnabledCount() {
        int i = 0;
        for (BlockConditionFeature condition : this.conditions) {
            if (!condition.hasCondition()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public BlockConditionsFeature clone(FeatureParentInterface newParent) {
        BlockConditionsFeature clone = new BlockConditionsFeature(newParent, this.getFeatureSettings());
        ArrayList<BlockConditionFeature> clones = new ArrayList<BlockConditionFeature>();
        for (BlockConditionFeature condition : this.conditions) {
            clones.add((BlockConditionFeature)condition.clone(clone));
        }
        clone.setConditions(clones);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.conditions);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BlockConditionsFeature) || !feature.getName().equals(this.getName())) continue;
            BlockConditionsFeature bCF = (BlockConditionsFeature)feature;
            ArrayList<BlockConditionFeature> clones = new ArrayList<BlockConditionFeature>();
            for (BlockConditionFeature condition : this.conditions) {
                clones.add(condition);
            }
            bCF.setConditions(clones);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        BlockConditionsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<BlockConditionFeature> getConditions() {
        return this.conditions;
    }

    @Generated
    public void setConditions(List<BlockConditionFeature> conditions) {
        this.conditions = conditions;
    }
}

