/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.placeholders.group;

import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeatureEditor;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeatureEditorManager;
import com.ssomar.score.features.custom.conditions.placeholders.placeholder.PlaceholderConditionFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderConditionGroupFeature
extends FeatureWithHisOwnEditor<PlaceholderConditionGroupFeature, PlaceholderConditionGroupFeature, PlaceholderConditionGroupFeatureEditor, PlaceholderConditionGroupFeatureEditorManager>
implements FeaturesGroup<PlaceholderConditionFeature> {
    private LinkedHashMap<String, PlaceholderConditionFeature> placeholdersConditions;
    private boolean notSaveIfItIsEmpty = false;

    public PlaceholderConditionGroupFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.placeholdersConditions);
        this.reset();
    }

    public PlaceholderConditionGroupFeature(FeatureParentInterface parent, FeatureSettingsInterface settings) {
        super(parent, settings);
        this.reset();
    }

    public PlaceholderConditionGroupFeature(FeatureParentInterface parent, FeatureSettingsInterface settings, boolean notSaveIfItIsEmpty) {
        super(parent, settings);
        this.notSaveIfItIsEmpty = notSaveIfItIsEmpty;
        this.reset();
    }

    @Override
    public void reset() {
        this.placeholdersConditions = new LinkedHashMap();
    }

    public boolean verify(Player player, Player target, Event event) {
        return this.verify(player, target, null, event);
    }

    public boolean verify(Player player, Player target, @Nullable StringPlaceholder sp, Event event) {
        boolean valid = true;
        for (PlaceholderConditionFeature attribute : this.placeholdersConditions.values()) {
            String[] split;
            if (attribute.verify(player, target, sp)) continue;
            String message = (String)((Optional)attribute.getMessageIfNotValid().getValue()).get();
            String messageForTarget = (String)((Optional)attribute.getMessageIfNotValidForTarget().getValue()).get();
            if (sp != null) {
                message = sp.replacePlaceholder(message);
                messageForTarget = sp.replacePlaceholder(messageForTarget);
            }
            for (String s : split = message.split("\n")) {
                SendMessage.sendMessageNoPlch(player, s);
            }
            if (target != null) {
                String[] split2;
                for (String s : split2 = messageForTarget.split("\n")) {
                    SendMessage.sendMessageNoPlch(target, s);
                }
            }
            if (event != null && event instanceof Cancellable && attribute.getCancelEventIfNotValid().getValue().booleanValue()) {
                ((Cancellable)event).setCancelled(true);
            }
            ActionInfo actionInfo = new ActionInfo("", sp);
            attribute.getConsoleCommandsIfError().runCommands(actionInfo, "");
            if (attribute.getStopCheckingOtherConditionsIfNotValid().getValue().booleanValue()) {
                return false;
            }
            valid = false;
        }
        return valid;
    }

    public boolean verifConditions(Player player, List<String> errors) {
        return this.verifConditions((OfflinePlayer)player, errors);
    }

    public boolean verifConditions(OfflinePlayer player, List<String> errors) {
        for (PlaceholderConditionFeature attribute : this.placeholdersConditions.values()) {
            if (attribute.verify(player, null, new StringPlaceholder())) continue;
            String message = (String)((Optional)attribute.getMessageIfNotValid().getValue()).get();
            String[] split = message.split("\n");
            errors.addAll(Arrays.asList(split));
            return false;
        }
        return true;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                PlaceholderConditionFeature attribute = new PlaceholderConditionFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.placeholdersConditions.put(attributeID, attribute);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfItIsEmpty && this.placeholdersConditions.isEmpty()) {
            return;
        }
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.placeholdersConditions.keySet()) {
            this.placeholdersConditions.get(enchantmentID).save(attributesSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    public String getConfigAsString() {
        String configuration = "";
        StringReader reader = new StringReader(configuration);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        this.save((ConfigurationSection)yamlConfiguration);
        configuration = yamlConfiguration.saveToString();
        return configuration;
    }

    @Override
    public PlaceholderConditionGroupFeature getValue() {
        return this;
    }

    @Override
    public PlaceholderConditionGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7&oPlaceholder cdt(s) added: &e" + this.placeholdersConditions.size();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PlaceholderConditionFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (PlaceholderConditionFeature x : this.placeholdersConditions.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public PlaceholderConditionGroupFeature clone(FeatureParentInterface newParent) {
        PlaceholderConditionGroupFeature eF = new PlaceholderConditionGroupFeature(newParent, this.getFeatureSettings());
        eF.setNotSaveIfItIsEmpty(this.notSaveIfItIsEmpty);
        LinkedHashMap<String, PlaceholderConditionFeature> newAttributes = new LinkedHashMap<String, PlaceholderConditionFeature>();
        for (String x : this.placeholdersConditions.keySet()) {
            newAttributes.put(x, this.placeholdersConditions.get(x).clone(eF));
        }
        eF.setPlaceholdersConditions(newAttributes);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.placeholdersConditions.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof PlaceholderConditionGroupFeature) || !feature.getName().equals(this.getName())) continue;
            PlaceholderConditionGroupFeature eF = (PlaceholderConditionGroupFeature)feature;
            eF.setPlaceholdersConditions(this.getPlaceholdersConditions());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        PlaceholderConditionGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "plchCdt";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.placeholdersConditions.containsKey(id)) continue;
            PlaceholderConditionFeature eF = new PlaceholderConditionFeature((FeatureParentInterface)this, id);
            this.placeholdersConditions.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, PlaceholderConditionFeature feature) {
        this.placeholdersConditions.remove(feature.getId());
    }

    @Generated
    public LinkedHashMap<String, PlaceholderConditionFeature> getPlaceholdersConditions() {
        return this.placeholdersConditions;
    }

    @Generated
    public boolean isNotSaveIfItIsEmpty() {
        return this.notSaveIfItIsEmpty;
    }

    @Generated
    public void setPlaceholdersConditions(LinkedHashMap<String, PlaceholderConditionFeature> placeholdersConditions) {
        this.placeholdersConditions = placeholdersConditions;
    }

    @Generated
    public void setNotSaveIfItIsEmpty(boolean notSaveIfItIsEmpty) {
        this.notSaveIfItIsEmpty = notSaveIfItIsEmpty;
    }
}

