/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.usedapi.TownyToolAPI;
import org.bukkit.entity.Player;

public class IfPlayerMustBeInHisTown
extends PlayerConditionFeature<BooleanFeature, IfPlayerMustBeInHisTown> {
    public IfPlayerMustBeInHisTown(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerMustBeInHisTown);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (((BooleanFeature)this.getCondition()).getValue(request.getSp()).booleanValue()) {
            Player player = request.getPlayer();
            if (SCore.hasTowny && !TownyToolAPI.playerIsInHisTown(player, player.getLocation())) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerMustBeInHisTown getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.ifPlayerMustBeInHisTown));
    }

    @Override
    public boolean hasCondition() {
        return ((BooleanFeature)this.getCondition()).isConfigured();
    }

    @Override
    public IfPlayerMustBeInHisTown getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerMustBeInHisTown(parent);
    }
}

