/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.drop.glowdrop;

import com.ssomar.score.SCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class GlowDropManager {
    private static GlowDropManager instance;
    private final HashMap<ChatColor, Team> teams;
    private Map<UUID, ChatColor> links = new HashMap<UUID, ChatColor>();

    public GlowDropManager() {
        instance = this;
        this.teams = new HashMap();
        this.links = new HashMap<UUID, ChatColor>();
        if (!SCore.is1v11Less()) {
            ScoreboardManager scoreboardManager = SCore.plugin.getServer().getScoreboardManager();
            for (ChatColor color : ChatColor.values()) {
                Team team;
                if (GlowDropManager.getBannedChatColorsForGlow().contains(color)) continue;
                try {
                    team = scoreboardManager.getMainScoreboard().registerNewTeam("team_" + color.name());
                }
                catch (IllegalArgumentException er) {
                    team = scoreboardManager.getMainScoreboard().getTeam("team_" + color.name());
                }
                if (team == null) continue;
                team.setColor(color);
                this.teams.put(color, team);
            }
        }
    }

    public static GlowDropManager getInstance() {
        if (instance == null) {
            instance = new GlowDropManager();
        }
        return instance;
    }

    public Optional<String> onRequestPlaceholder(OfflinePlayer player, String params) {
        if (params.startsWith("cmd-glow")) {
            if (this.links.containsKey(player.getUniqueId())) {
                return Optional.of("&" + this.links.get(player.getUniqueId()).getChar());
            }
            return Optional.of("");
        }
        return Optional.empty();
    }

    public static List<ChatColor> getBannedChatColorsForGlow() {
        ArrayList<ChatColor> banned = new ArrayList<ChatColor>();
        banned.add(ChatColor.MAGIC);
        banned.add(ChatColor.BOLD);
        banned.add(ChatColor.STRIKETHROUGH);
        banned.add(ChatColor.UNDERLINE);
        banned.add(ChatColor.ITALIC);
        return banned;
    }

    public void addGlow(Entity entity, ChatColor color) {
        if (GlowDropManager.getBannedChatColorsForGlow().contains(color)) {
            color = ChatColor.WHITE;
        }
        this.links.put(entity.getUniqueId(), color);
        if (this.teams.containsKey(color)) {
            try {
                Team team = this.teams.get(color);
                team.addEntry(entity.getUniqueId().toString());
                if (entity instanceof OfflinePlayer) {
                    team.addEntry(((OfflinePlayer)entity).getName());
                }
                entity.setGlowing(true);
            }
            catch (Exception e) {
                SCore.plugin.getLogger().severe("Error with glow drop, the scoreboard team is not registered ! You have probably a plugin that purges the teams, try to find it and disable the purge if you want the glow drop.");
            }
        }
    }

    public void removeGlow(Entity entity, ChatColor color) {
        this.links.remove(entity.getUniqueId());
        if (this.teams.containsKey(color)) {
            Team team = this.teams.get(color);
            if (team.hasEntry(entity.getUniqueId().toString())) {
                team.removeEntry(entity.getUniqueId().toString());
            }
            if (entity instanceof OfflinePlayer && team.hasPlayer((OfflinePlayer)entity)) {
                team.removePlayer((OfflinePlayer)entity);
            }
            entity.setGlowing(false);
        }
    }
}

