/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.entities.group;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.entities.entity.EntityTypeForGroupFeature;
import com.ssomar.score.features.custom.entities.group.EntityTypeGroupFeatureEditor;
import com.ssomar.score.features.custom.entities.group.EntityTypeGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EntityTypeGroupFeature
extends FeatureWithHisOwnEditor<EntityTypeGroupFeature, EntityTypeGroupFeature, EntityTypeGroupFeatureEditor, EntityTypeGroupFeatureEditorManager>
implements FeaturesGroup<EntityTypeForGroupFeature> {
    private Map<String, EntityTypeForGroupFeature> entityTypes;
    private boolean hasID;
    private boolean useTheParentSection;
    private boolean notSaveIfEmpty;

    public EntityTypeGroupFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, boolean hasID, boolean useTheParentSection, boolean notSaveIfEmpty) {
        super(parent, featureSettings);
        this.useTheParentSection = useTheParentSection;
        this.hasID = hasID;
        this.notSaveIfEmpty = notSaveIfEmpty;
        this.reset();
    }

    @Override
    public void reset() {
        this.entityTypes = new HashMap<String, EntityTypeForGroupFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error;
        block5: {
            block4: {
                error = new ArrayList<String>();
                if (!this.hasID) break block4;
                if (!config.isConfigurationSection(this.getName())) break block5;
                ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
                for (String attributeID : enchantmentsSection.getKeys(false)) {
                    EntityTypeForGroupFeature attribute = new EntityTypeForGroupFeature((FeatureParentInterface)this, attributeID);
                    List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                    if (!subErrors.isEmpty()) {
                        error.addAll(subErrors);
                        continue;
                    }
                    this.entityTypes.put(attributeID, attribute);
                }
                break block5;
            }
            List configs = config.getStringList(this.getName());
            for (String strConfig : configs) {
                UUID uuid = UUID.randomUUID();
                EntityTypeForGroupFeature entityType = new EntityTypeForGroupFeature((FeatureParentInterface)this, uuid.toString());
                List<String> subErrors = entityType.load(plugin, strConfig, isPremiumLoading);
                if (!subErrors.isEmpty()) {
                    error.addAll(subErrors);
                    continue;
                }
                this.entityTypes.put(uuid.toString(), entityType);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfEmpty && this.entityTypes.size() == 0) {
            return;
        }
        if (this.hasID) {
            ConfigurationSection attributesSection = config.createSection(this.getName());
            for (String enchantmentID : this.entityTypes.keySet()) {
                this.entityTypes.get(enchantmentID).save(attributesSection);
            }
        } else {
            ArrayList<String> configs = new ArrayList<String>();
            for (EntityType entityType : this.getEntityTypeList()) {
                configs.add(entityType.name());
            }
            config.set(this.getName(), configs);
        }
    }

    @Override
    public EntityTypeGroupFeature getValue() {
        return this;
    }

    public List<EntityType> getEntityTypeList() {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (EntityTypeForGroupFeature entityType : this.entityTypes.values()) {
            entityTypes.add((EntityType)((Optional)entityType.getValue().getEntityType().getValue()).get());
        }
        return entityTypes;
    }

    @Override
    public EntityTypeGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oEntityType(s) added: &e" + this.entityTypes.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public EntityTypeForGroupFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (EntityTypeForGroupFeature x : this.entityTypes.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public EntityTypeGroupFeature clone(FeatureParentInterface newParent) {
        EntityTypeGroupFeature eF = new EntityTypeGroupFeature(newParent, this.getFeatureSettings(), this.hasID, this.useTheParentSection, this.notSaveIfEmpty);
        HashMap<String, EntityTypeForGroupFeature> newEntityTypes = new HashMap<String, EntityTypeForGroupFeature>();
        for (String key : this.entityTypes.keySet()) {
            newEntityTypes.put(key, this.entityTypes.get(key).clone(eF));
        }
        eF.setEntityTypes(newEntityTypes);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.entityTypes.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (!this.useTheParentSection) {
            if (section.isConfigurationSection(this.getName())) {
                return section.getConfigurationSection(this.getName());
            }
            return section.createSection(this.getName());
        }
        return section;
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof EntityTypeGroupFeature)) continue;
            EntityTypeGroupFeature eF = (EntityTypeGroupFeature)feature;
            eF.setEntityTypes(this.entityTypes);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        EntityTypeGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "eT";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.entityTypes.containsKey(id)) continue;
            EntityTypeForGroupFeature eF = new EntityTypeForGroupFeature((FeatureParentInterface)this, id);
            this.entityTypes.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, EntityTypeForGroupFeature feature) {
        this.entityTypes.remove(feature.getId());
    }

    @Generated
    public Map<String, EntityTypeForGroupFeature> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public boolean isHasID() {
        return this.hasID;
    }

    @Generated
    public boolean isUseTheParentSection() {
        return this.useTheParentSection;
    }

    @Generated
    public boolean isNotSaveIfEmpty() {
        return this.notSaveIfEmpty;
    }

    @Generated
    public void setEntityTypes(Map<String, EntityTypeForGroupFeature> entityTypes) {
        this.entityTypes = entityTypes;
    }

    @Generated
    public void setHasID(boolean hasID) {
        this.hasID = hasID;
    }

    @Generated
    public void setUseTheParentSection(boolean useTheParentSection) {
        this.useTheParentSection = useTheParentSection;
    }

    @Generated
    public void setNotSaveIfEmpty(boolean notSaveIfEmpty) {
        this.notSaveIfEmpty = notSaveIfEmpty;
    }
}

