/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.experience;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RequiredExperience
extends FeatureWithHisOwnEditor<RequiredExperience, RequiredExperience, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private IntegerFeature experience;
    private ColoredStringFeature errorMessage;
    private BooleanFeature cancelEventIfError;

    public RequiredExperience(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.requiredExperience);
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            if (!isPremiumLoading) {
                error.add("&cERROR, Couldn't load the Required Experience value of " + this.getName() + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium feature !");
                return error;
            }
            this.experience.load(plugin, section, isPremiumLoading);
            this.errorMessage.load(plugin, section, isPremiumLoading);
            this.cancelEventIfError.load(plugin, section, isPremiumLoading);
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (((Optional)this.experience.getValue()).isPresent() && (Integer)((Optional)this.experience.getValue()).get() > 0) {
            ConfigurationSection requiredLevelSection = config.createSection(this.getName());
            this.experience.save(requiredLevelSection);
            this.errorMessage.save(requiredLevelSection);
            this.cancelEventIfError.save(requiredLevelSection);
            if (this.isSavingOnlyIfDiffDefault() && requiredLevelSection.getKeys(false).isEmpty()) {
                config.set(this.getName(), null);
                return;
            }
            if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
                config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
            }
        }
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        int actualExperience;
        if (this.experience.getValue(player.getUniqueId(), sp).isPresent() && this.experience.getValue(player.getUniqueId(), sp).get() > 0 && (actualExperience = this.getExpAtLevel(player.getLevel()) + (int)((float)player.getExpToLevel() * player.getExp())) < (Integer)((Optional)this.experience.getValue()).get()) {
            if (((Optional)this.errorMessage.getValue()).isPresent()) {
                String message = (String)((Optional)this.errorMessage.getValue()).get();
                message = sp.replacePlaceholder(message);
                SendMessage.sendMessageNoPlch(player, message);
            }
            if (this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
                ((Cancellable)event).setCancelled(true);
            }
            return false;
        }
        return true;
    }

    public int getExpToLevelUp(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public int getExpAtLevel(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        if (this.experience.getValue(player.getUniqueId(), sp).isPresent() && this.experience.getValue(player.getUniqueId(), sp).get() > 0) {
            int newAmount = this.getExpAtLevel(player.getLevel()) + (int)((float)player.getExpToLevel() * player.getExp());
            newAmount -= this.experience.getValue(player.getUniqueId(), sp).get().intValue();
            int level = 0;
            int i = 0;
            while (i < 10000 && this.getExpAtLevel(i) <= newAmount) {
                level = i++;
            }
            player.setLevel(level);
            float exp = (float)(newAmount - this.getExpAtLevel(level)) / (float)this.getExpToLevelUp(level);
            player.setExp(exp);
        }
    }

    @Override
    public RequiredExperience getValue() {
        return this;
    }

    @Override
    public RequiredExperience initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oRequired experience: &e" + ((Optional)this.experience.getValue()).get();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredExperience clone(FeatureParentInterface parent) {
        RequiredExperience requiredLevel = new RequiredExperience(parent);
        requiredLevel.setExperience(this.experience.clone(requiredLevel));
        requiredLevel.setErrorMessage(this.errorMessage.clone(requiredLevel));
        requiredLevel.setCancelEventIfError(this.cancelEventIfError.clone(requiredLevel));
        return requiredLevel;
    }

    @Override
    public void reset() {
        this.experience = new IntegerFeature(this.getParent(), Optional.of(0), FeatureSettingsSCore.requiredExperience);
        this.errorMessage = new ColoredStringFeature(this.getParent(), Optional.of("&4&l>> &cError you don't have the required experience"), FeatureSettingsSCore.errorMessage);
        this.cancelEventIfError = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.cancelEventIfError);
    }

    @Override
    public void openEditor(Player player) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return;
        }
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return Arrays.asList(this.experience, this.errorMessage, this.cancelEventIfError);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo() + ".(" + this.getName() + ")";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RequiredExperience)) continue;
            RequiredExperience requiredLevel = (RequiredExperience)feature;
            requiredLevel.setExperience(this.experience);
            requiredLevel.setErrorMessage(this.errorMessage);
            requiredLevel.setCancelEventIfError(this.cancelEventIfError);
            break;
        }
    }

    @Generated
    public IntegerFeature getExperience() {
        return this.experience;
    }

    @Generated
    public ColoredStringFeature getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public BooleanFeature getCancelEventIfError() {
        return this.cancelEventIfError;
    }

    @Generated
    public void setExperience(IntegerFeature experience) {
        this.experience = experience;
    }

    @Generated
    public void setErrorMessage(ColoredStringFeature errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setCancelEventIfError(BooleanFeature cancelEventIfError) {
        this.cancelEventIfError = cancelEventIfError;
    }
}

