/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireClicksOrOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BooleanFeature
extends FeatureAbstract<Boolean, BooleanFeature>
implements FeatureRequireClicksOrOneMessageInEditor,
Serializable {
    private boolean value;
    private boolean noValueUsePlaceholder;
    private boolean defaultValue;
    private String placeholder;

    public BooleanFeature(FeatureParentInterface parent, Boolean defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.noValueUsePlaceholder = false;
        this.reset();
    }

    @Override
    public Material getEditorMaterial() {
        return super.getEditorMaterial() == null ? Material.LEVER : super.getEditorMaterial();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String valueStr = config.getString(this.getName(), "NULL");
        if (valueStr.contains("%")) {
            this.placeholder = valueStr;
            this.value = false;
            this.noValueUsePlaceholder = true;
        } else {
            this.placeholder = null;
            this.value = config.getBoolean(this.getName(), this.defaultValue);
            this.noValueUsePlaceholder = false;
            this.setPremium(isPremiumLoading);
            FeatureReturnCheckPremium<Boolean> checkPremium = this.checkPremium("Boolean", this.value, Optional.of(this.defaultValue), isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = checkPremium.getNewValue();
            }
        }
        return errors;
    }

    @Override
    public BooleanFeature clone(FeatureParentInterface newParent) {
        BooleanFeature clone = new BooleanFeature(newParent, this.defaultValue, this.getFeatureSettings());
        clone.setValue(this.value);
        clone.setPlaceholder(this.placeholder);
        clone.setNoValueUsePlaceholder(this.noValueUsePlaceholder);
        clone.setPremium(this.isPremium());
        return clone;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.isSavingOnlyIfDiffDefault() && !this.noValueUsePlaceholder && this.value == this.defaultValue) {
            config.set(this.getName(), null);
            return;
        }
        if (this.placeholder != null) {
            config.set(this.getName(), (Object)this.placeholder);
        } else if (!this.noValueUsePlaceholder) {
            config.set(this.getName(), (Object)this.value);
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        } else if (SCore.is1v19Plus()) {
            config.setComments(this.getName(), null);
        }
    }

    public Boolean getValue(@Nullable StringPlaceholder sp) {
        return this.getValue(null, sp);
    }

    public Boolean getValue(@Nullable UUID playerUUID, @Nullable StringPlaceholder sp) {
        if (this.placeholder != null) {
            String placeholderStr = this.placeholder;
            if (sp != null) {
                placeholderStr = sp.replacePlaceholder(placeholderStr);
            }
            placeholderStr = StringPlaceholder.replacePlaceholderOfPAPI(placeholderStr, playerUUID);
            return Boolean.valueOf(placeholderStr);
        }
        if (!this.noValueUsePlaceholder) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public Boolean getValue() {
        if (!this.noValueUsePlaceholder) {
            return this.value;
        }
        if (this.placeholder != null) {
            String placeholderStr = this.placeholder;
            placeholderStr = new StringPlaceholder().replacePlaceholderOfPAPI(placeholderStr);
            return Boolean.valueOf(placeholderStr);
        }
        return this.defaultValue;
    }

    public boolean isConfigured() {
        return !this.noValueUsePlaceholder && this.value || this.placeholder != null;
    }

    @Override
    public BooleanFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "&8>> &6Enter placeholder: &eMIDDLE &a(Creative only)";
        finalDescription[finalDescription.length - 2] = "&7(Be sure your placeholder return &atrue &7or &cfalse&7)";
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (!this.noValueUsePlaceholder) {
            gui.updateBoolean(this.getEditorName(), this.value);
        } else {
            gui.updateCurrently(this.getEditorName(), this.placeholder);
        }
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
        this.noValueUsePlaceholder = false;
        this.placeholder = null;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
        if (this.isRequirePremium() && !this.isPremium()) {
            return;
        }
        ((GUI)manager.getCache().get(editor)).changeBoolean(this.getEditorName());
        this.value = this.getValue() == false;
        this.noValueUsePlaceholder = false;
        this.placeholder = null;
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public void setValue(Optional<Boolean> value) {
        this.value = value.orElse(this.defaultValue);
    }

    @Override
    public void askInEditor(final Player editor, NewGUIManager manager) {
        manager.requestWriting.put(editor, this.getEditorName());
        Runnable runnable = new Runnable(){
            final /* synthetic */ BooleanFeature this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                editor.closeInventory();
            }
        };
        SCore.schedulerHook.runTask(runnable, 0L);
        BooleanFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter the placeholder or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(((GUI)manager.getCache().get(editor)).getCurrently(this.getEditorName()))));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current placeholder")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new placeholder boolean")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        editor.spigot().sendMessage((BaseComponent)message);
        BooleanFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        if (message.contains("%")) {
            return Optional.empty();
        }
        return Optional.of(StringConverter.coloredString("&4&l[ERROR] &cThe message you entered is not a placeholder"));
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        this.value = false;
        this.noValueUsePlaceholder = true;
        this.placeholder = message;
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        if (this.noValueUsePlaceholder) {
            this.value = this.defaultValue;
        }
        this.noValueUsePlaceholder = false;
        this.placeholder = null;
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public boolean isNoValueUsePlaceholder() {
        return this.noValueUsePlaceholder;
    }

    @Generated
    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Generated
    public void setNoValueUsePlaceholder(boolean noValueUsePlaceholder) {
        this.noValueUsePlaceholder = noValueUsePlaceholder;
    }

    @Generated
    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }
}

