/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class ColorIntegerFeature
extends FeatureAbstract<Optional<Integer>, ColorIntegerFeature>
implements FeatureRequireOneMessageInEditor {
    private Optional<Integer> value;
    private Optional<Integer> defaultValue;
    private Optional<String> placeholder;

    public ColorIntegerFeature(FeatureParentInterface parent, Optional<Integer> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.reset();
    }

    public static IntegerFeature buildNull() {
        return new IntegerFeature(null, Optional.empty(), null);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String valueStr = config.getString(this.getName(), "NULL");
        if (valueStr.contains("%")) {
            this.placeholder = Optional.of(valueStr);
            this.value = Optional.empty();
        } else {
            this.placeholder = Optional.empty();
            Optional<Integer> valuePotential = NTools.getInteger(valueStr);
            if (valuePotential.isPresent()) {
                this.value = valuePotential;
                FeatureReturnCheckPremium<Integer> checkPremium = this.checkPremium("Integer", valuePotential.get(), this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.ofNullable(checkPremium.getNewValue());
                }
            } else {
                if (!valueStr.equals("NULL")) {
                    errors.add("&cERROR, Couldn't load the color integer value of " + this.getName() + " from config, value: " + valueStr + " &7&o" + this.getParent().getParentInfo());
                }
                this.value = this.defaultValue;
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.placeholder.isPresent()) {
            config.set(this.getName(), (Object)this.placeholder.get());
        } else if (((Optional)this.getValue()).isPresent()) {
            config.set(this.getName(), ((Optional)this.getValue()).get());
        }
    }

    public Optional<Integer> getValue(@Nullable UUID playerUUID, @Nullable StringPlaceholder sp) {
        if (this.placeholder.isPresent()) {
            Optional<Integer> valuePotential;
            String placeholderStr = this.placeholder.get();
            if (sp != null) {
                placeholderStr = sp.replacePlaceholder(placeholderStr);
            }
            if ((valuePotential = NTools.getInteger(placeholderStr = StringPlaceholder.replacePlaceholderOfPAPI(placeholderStr, playerUUID))).isPresent()) {
                return valuePotential;
            }
        } else if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public Optional<Integer> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        if (this.placeholder.isPresent()) {
            String placeholderStr = this.placeholder.get();
            Optional<Integer> valuePotential = NTools.getInteger(placeholderStr = new StringPlaceholder().replacePlaceholderOfPAPI(placeholderStr));
            if (valuePotential.isPresent()) {
                return valuePotential;
            }
        }
        return this.defaultValue;
    }

    @Override
    public ColorIntegerFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (this.placeholder.isPresent()) {
            gui.updateCurrently(this.getEditorName(), this.placeholder.get());
        } else if (this.value.isPresent()) {
            gui.updateInt(this.getEditorName(), (Integer)((Optional)this.getValue()).get());
        } else {
            gui.updateDouble(this.getEditorName(), 0.0);
        }
    }

    @Override
    public ColorIntegerFeature clone(FeatureParentInterface newParent) {
        ColorIntegerFeature clone = new ColorIntegerFeature(newParent, this.defaultValue, this.getFeatureSettings());
        clone.setValue(this.value);
        clone.setPlaceholder(this.getPlaceholder());
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
        this.placeholder = Optional.empty();
    }

    @Override
    public void askInEditor(Player editor, NewGUIManager manager) {
        manager.requestWriting.put(editor, this.getEditorName());
        editor.closeInventory();
        ColorIntegerFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter an color in integer or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(((GUI)manager.getCache().get(editor)).getCurrently(this.getEditorName()))));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current color integer")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new color integer")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        TextComponent info = new TextComponent(StringConverter.coloredString("&e&l[GET COLOR WEBSITE]"));
        info.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.tydac.ch/color/"));
        info.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here, select your color and copy the mapInfo Color")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)info);
        editor.spigot().sendMessage((BaseComponent)message);
        ColorIntegerFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        if (message.contains("%")) {
            return Optional.empty();
        }
        Optional<Integer> verify = NTools.getInteger(StringConverter.decoloredString(message).trim());
        if (verify.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(StringConverter.coloredString("&4&l[ERROR] &cThe message you entered is not a color integer or a placeholder"));
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        if ((message = StringConverter.decoloredString(message).trim()).contains("%")) {
            this.placeholder = Optional.of(message);
            this.value = Optional.empty();
        } else {
            this.placeholder = Optional.empty();
            this.value = NTools.getInteger(message);
        }
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        this.value = Optional.empty();
        this.placeholder = Optional.empty();
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public Optional<Integer> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Optional<String> getPlaceholder() {
        return this.placeholder;
    }

    @Generated
    public void setValue(Optional<Integer> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Integer> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setPlaceholder(Optional<String> placeholder) {
        this.placeholder = placeholder;
    }
}

