/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MyFurnitureFeature
extends FeatureAbstract<Optional<Furniture>, MyFurnitureFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<String> value = Optional.empty();
    private boolean checkAlreadyLinked = true;

    public MyFurnitureFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "");
        this.value = colorStr.isEmpty() ? Optional.empty() : Optional.of(colorStr);
        return errors;
    }

    public Optional<SObjectBuildable> getBuildable() {
        if (this.value.isPresent() && Dependency.MY_FURNITURE.isEnabled() && FurnitureManager.getInstance().isValidID(this.value.get())) {
            return Optional.of((SObjectBuildable)FurnitureManager.getInstance().getFurniture(this.value.get()).get());
        }
        return Optional.empty();
    }

    @Override
    public void save(ConfigurationSection config) {
        this.value.ifPresent(s -> config.set(this.getName(), s));
    }

    @Override
    public Optional<Furniture> getValue() {
        if (this.value.isPresent() && Dependency.MY_FURNITURE.isEnabled() && FurnitureManager.getInstance().isValidID(this.value.get())) {
            return FurnitureManager.getInstance().getFurniture(this.value.get());
        }
        return Optional.empty();
    }

    public Optional<String> getValueID() {
        return this.value;
    }

    @Override
    public MyFurnitureFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "&8>> &6DOUBLE CLICK : &bOPEN EDITOR";
        finalDescription[finalDescription.length - 2] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        ItemStack item = new ItemStack(this.getEditorMaterial());
        if (this.value.isPresent() && Dependency.MY_FURNITURE.isEnabled() && FurnitureManager.getInstance().isValidID(this.value.get())) {
            item = ((Furniture)FurnitureManager.getInstance().getFurniture(this.value.get()).get()).getIconItem();
        }
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (Dependency.MY_FURNITURE.isEnabled()) {
            if (this.value.isPresent() && FurnitureManager.getInstance().isValidID(this.value.get())) {
                this.updateMyFurniture(this.value.get(), gui, true);
            } else {
                this.updateMyFurniture((String)FurnitureManager.getInstance().getLoadedObjectsIDs().get(0), gui, true);
            }
        } else {
            this.updateMyFurniture(null, gui, true);
        }
    }

    @Override
    public MyFurnitureFeature clone(FeatureParentInterface newParent) {
        MyFurnitureFeature clone = new MyFurnitureFeature(newParent, this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = Optional.empty();
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        if (Dependency.MY_FURNITURE.isEnabled()) {
            String id = this.getMyFurniture((GUI)manager.getCache().get(editor)).get();
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            id = this.nextMyFurniture(id);
            this.updateMyFurniture(id, (GUI)manager.getCache().get(editor), true);
        }
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        if (Dependency.MY_FURNITURE.isEnabled()) {
            String id = this.getMyFurniture((GUI)manager.getCache().get(editor)).get();
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            id = this.prevMyFurniture(id);
            this.updateMyFurniture(id, (GUI)manager.getCache().get(editor), false);
        }
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        if (Dependency.MY_FURNITURE.isEnabled()) {
            this.updateMyFurniture(this.nextMyFurniture(this.getMyFurniture((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor), true);
        }
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        if (Dependency.MY_FURNITURE.isEnabled()) {
            this.updateMyFurniture(this.prevMyFurniture(this.getMyFurniture((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor), false);
        }
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        this.rightClicked(editor, manager);
        this.rightClicked(editor, manager);
        if (Dependency.MY_FURNITURE.isEnabled()) {
            Object furniture = this.getValue();
            ((Optional)furniture).ifPresent(furniture1 -> furniture1.openEditor(editor));
        }
        return true;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public String nextMyFurniture(String id) {
        boolean next = false;
        for (String check : this.getSortMyFurniture()) {
            if (check.equals(id)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortMyFurniture().get(0);
    }

    public String prevMyFurniture(String id) {
        int i = -1;
        int cpt = 0;
        for (String check : this.getSortMyFurniture()) {
            if (check.equals(id)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortMyFurniture().get(this.getSortMyFurniture().size() - 1);
        }
        return this.getSortMyFurniture().get(cpt - 1);
    }

    public void updateMyFurniture(String id, GUI gui, boolean next) {
        if (id == null) {
            id = "NULLLLL";
        }
        Map<String, String> alreadyLinkedMap = this.getMyFurnitureAlreadyLinkedToAnEI(id);
        Set<String> alreadyLinked = alreadyLinkedMap.keySet();
        while (alreadyLinked.contains(id)) {
            if (next) {
                id = this.nextMyFurniture(id);
                continue;
            }
            id = this.prevMyFurniture(id);
        }
        this.value = Optional.of(id);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        int slot = gui.getInv().first(item);
        this.initItemParentEditor(gui, slot);
        item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 4);
        int maxSize = lore.size();
        if ((maxSize += this.getSortMyFurniture().size()) > 17) {
            maxSize = 17;
        }
        if (Dependency.MY_FURNITURE.isEnabled()) {
            boolean find = false;
            for (String check : this.getSortMyFurniture()) {
                if (id.equals(check)) {
                    lore.add(StringConverter.coloredString("&2\u27a4 &a" + id));
                    find = true;
                    continue;
                }
                if (!find) continue;
                if (lore.size() == maxSize) break;
                if (alreadyLinked.contains(check)) {
                    lore.add(StringConverter.coloredString("&6\u2726 &e" + check + " &7Already linked to an EI (ID: " + alreadyLinkedMap.get(check) + ")"));
                    continue;
                }
                lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
            }
            for (String check : this.getSortMyFurniture()) {
                if (lore.size() != maxSize) {
                    if (alreadyLinked.contains(check)) {
                        lore.add(StringConverter.coloredString("&6\u2726 &e" + check + " &7Already linked to an EI (ID: " + alreadyLinkedMap.get(check) + ")"));
                        continue;
                    }
                    lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
                    continue;
                }
                break;
            }
        } else {
            lore.add(StringConverter.coloredString("&4\u27a4 &cYou must have &6ExecutableItems"));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item);
    }

    public Optional<String> getMyFurniture(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            if (str.contains("You must have &6ExecutableItems")) {
                return Optional.empty();
            }
            str = StringConverter.decoloredString(str);
            return Optional.ofNullable(str.split("\u27a4 ")[1]);
        }
        return Optional.empty();
    }

    public List<String> getSortMyFurniture() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (Dependency.MY_FURNITURE.isEnabled()) {
            for (String id : FurnitureManager.getInstance().getLoadedObjectsIDs()) {
                map.put(id, id);
            }
        }
        return new ArrayList<String>(map.values());
    }

    public Map<String, String> getMyFurnitureAlreadyLinkedToAnEI(String idToIgnore) {
        HashMap<String, String> list = new HashMap<String, String>();
        if (Dependency.MY_FURNITURE.isEnabled()) {
            for (Furniture furniture : FurnitureManager.getInstance().getLoadedObjects()) {
                if (!furniture.getEi().getValueID().isPresent() || furniture.getId().equals(idToIgnore)) continue;
                list.put(furniture.getId(), furniture.getEi().getValueID().get());
            }
        }
        return list;
    }

    @Generated
    public boolean isCheckAlreadyLinked() {
        return this.checkAlreadyLinked;
    }

    @Generated
    public void setValue(Optional<String> value) {
        this.value = value;
    }

    @Generated
    public void setCheckAlreadyLinked(boolean checkAlreadyLinked) {
        this.checkAlreadyLinked = checkAlreadyLinked;
    }
}

