/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireClicksOrOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ParticleTypeFeature
extends FeatureAbstract<Optional<Particle>, ParticleTypeFeature>
implements FeatureRequireClicksOrOneMessageInEditor {
    private Optional<Particle> value;
    private Optional<Particle> defaultValue;

    public ParticleTypeFeature(FeatureParentInterface parent, Optional<Particle> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            Particle particle = Particle.valueOf((String)colorStr);
            this.value = Optional.ofNullable(particle);
            FeatureReturnCheckPremium<Particle> checkPremium = this.checkPremium("Particle", particle, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            if (!colorStr.equals("NULL")) {
                errors.add("&cERROR, Couldn't load the Particle value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Particles available: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Particle.html");
            }
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(material -> config.set(this.getName(), (Object)material.name()));
    }

    @Override
    public Optional<Particle> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public ParticleTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 2] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        finalDescription[finalDescription.length - 1] = "&8>> &6Type manually: &eMIDDLE &a(Creative only)";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        Particle finalValue = ((Optional)value).orElse(Particle.CLOUD);
        this.updateParticle(finalValue, gui);
    }

    @Override
    public ParticleTypeFeature clone(FeatureParentInterface newParent) {
        ParticleTypeFeature clone = new ParticleTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        Particle particle = this.getParticle((GUI)manager.getCache().get(editor));
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        particle = this.nextParticle(particle);
        this.updateParticle(particle, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        Particle particle = this.getParticle((GUI)manager.getCache().get(editor));
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        particle = this.prevParticle(particle);
        this.updateParticle(particle, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateParticle(this.nextParticle(this.getParticle((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateParticle(this.prevParticle(this.getParticle((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public Particle nextParticle(Particle particle) {
        boolean next = false;
        for (Particle check : this.getSortParticles()) {
            if (check.equals((Object)particle)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortParticles().get(0);
    }

    public Particle prevParticle(Particle particle) {
        int i = -1;
        int cpt = 0;
        for (Particle check : this.getSortParticles()) {
            if (check.equals((Object)particle)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortParticles().get(this.getSortParticles().size() - 1);
        }
        return this.getSortParticles().get(cpt - 1);
    }

    public void updateParticle(Particle particle, GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        this.value = Optional.of(particle);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 4);
        boolean find = false;
        for (Particle check : this.getSortParticles()) {
            if (particle.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + particle.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (Particle check : this.getSortParticles()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Particle getParticle(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return Particle.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<Particle> getSortParticles() {
        TreeMap<String, Particle> map = new TreeMap<String, Particle>();
        for (Particle l : Particle.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<Particle>(map.values());
    }

    @Override
    public void askInEditor(final Player editor, NewGUIManager manager) {
        manager.requestWriting.put(editor, this.getEditorName());
        Runnable runnable = new Runnable(){
            final /* synthetic */ ParticleTypeFeature this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                editor.closeInventory();
            }
        };
        SCore.schedulerHook.runEntityTaskAsap(runnable, null, (Entity)editor);
        ParticleTypeFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter the particle or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(((GUI)manager.getCache().get(editor)).getCurrently(this.getEditorName()))));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current particle")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new particle")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        editor.spigot().sendMessage((BaseComponent)message);
        ParticleTypeFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        try {
            Particle.valueOf((String)StringConverter.decoloredString(message).trim().toUpperCase());
        }
        catch (Exception e) {
            return Optional.of(StringConverter.coloredString("&4&l[ERROR] &cThe message you entered is not a particle"));
        }
        return Optional.empty();
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        this.value = Optional.of(Particle.valueOf((String)StringConverter.decoloredString(message).trim().toUpperCase()));
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        this.value = Optional.empty();
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public Optional<Particle> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<Particle> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Particle> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

