/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class ListFeatureAbstract<T, Y extends FeatureInterface<List<T>, Y>>
extends FeatureAbstract<List<T>, Y>
implements FeatureRequireSubTextEditorInEditor {
    private List<T> values;
    private List<T> blacklistedValues;
    private List<T> defaultValue;
    private String featureName;

    public ListFeatureAbstract(FeatureParentInterface parent, String featureName, List<T> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.featureName = featureName;
        this.reset();
    }

    public ListFeatureAbstract() {
        super(null, null);
        this.defaultValue = new ArrayList<T>();
        this.featureName = null;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        List entries = config.getStringList(this.getName());
        return this.load(plugin, entries, isPremiumLoading);
    }

    public List<String> load(SPlugin plugin, List<String> entries, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> forValue = new ArrayList<String>();
        ArrayList<String> forBlacklistedValues = new ArrayList<String>();
        for (String s : entries) {
            if (SCore.isMohist()) {
                s = s.replaceAll("\u00c3\u201a\u00c2", "");
            }
            if (s.startsWith("!")) {
                s = s.substring(1);
                forBlacklistedValues.add(s);
                continue;
            }
            forValue.add(s);
        }
        this.values = this.loadValues(forValue, errors);
        this.blacklistedValues = this.loadValues(forBlacklistedValues, errors);
        FeatureReturnCheckPremium<List<T>> checkPremium = this.checkPremium(this.featureName, this.values, Optional.of(this.defaultValue), isPremiumLoading);
        if (checkPremium.isHasError()) {
            this.values = checkPremium.getNewValue();
            errors.add(checkPremium.getError());
        }
        return errors;
    }

    public abstract List<T> loadValues(List<String> var1, List<String> var2);

    public abstract String transfromToString(T var1);

    @Override
    public void save(ConfigurationSection config) {
        ArrayList<T> valuesTyped = new ArrayList<T>(this.values);
        valuesTyped.addAll(this.blacklistedValues);
        if (this.isSavingOnlyIfDiffDefault() && new HashSet<T>(this.defaultValue).containsAll(valuesTyped)) {
            config.set(this.getName(), null);
            return;
        }
        config.set(this.getName(), this.getCurrentValues());
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    public Y initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return (Y)this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        gui.updateConditionList(this.getEditorName(), this.getCurrentValues(), "&cEMPTY");
    }

    @Override
    public void reset() {
        this.values = new ArrayList<T>(this.defaultValue);
        this.blacklistedValues = new ArrayList<T>();
    }

    @Override
    public List<T> getValue() {
        return this.values;
    }

    @Override
    public List<String> getCurrentValues() {
        ArrayList<String> currentValues = new ArrayList<String>();
        for (T value : this.values) {
            currentValues.add(this.transfromToString(value));
        }
        for (T value : this.blacklistedValues) {
            currentValues.add("!" + this.transfromToString(value));
        }
        return currentValues;
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        message = message.replace("!", "");
        return this.verifyMessage(message);
    }

    public abstract Optional<String> verifyMessage(String var1);

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        List<String> values = StringConverter.coloredString(manager.currentWriting.get(editor));
        this.load((SPlugin)SCore.plugin, values, this.isRequirePremium());
        manager.requestWriting.remove(editor);
        manager.activeTextEditor.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public List<T> getValues() {
        return this.values;
    }

    @Generated
    public List<T> getBlacklistedValues() {
        return this.blacklistedValues;
    }

    @Generated
    public List<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public String getFeatureName() {
        return this.featureName;
    }

    @Generated
    public void setValues(List<T> values) {
        this.values = values;
    }

    @Generated
    public void setBlacklistedValues(List<T> blacklistedValues) {
        this.blacklistedValues = blacklistedValues;
    }

    @Generated
    public void setDefaultValue(List<T> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }
}

