/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.hardness;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.ssomar.score.SCore;
import com.ssomar.score.hardness.HardnessModifier;
import com.ssomar.score.hardness.hardness.manager.HardnessesManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class HardnessesHandler {
    private final Map<Location, BukkitScheduler> breakerPerLocation = new HashMap<Location, BukkitScheduler>();
    private final ProtocolManager protocolManager;
    private final PacketAdapter listener = new PacketAdapter((Plugin)SCore.plugin, ListenerPriority.LOW, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

        public void onPacketReceiving(PacketEvent event) {
            EnumWrappers.PlayerDigType type;
            PacketContainer packet = event.getPacket();
            final Player player = event.getPlayer();
            ItemStack itemNotFinal = null;
            itemNotFinal = SCore.is1v12Less() ? player.getInventory().getItemInHand() : player.getInventory().getItemInMainHand();
            final ItemStack item = itemNotFinal;
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            StructureModifier dataTemp = packet.getBlockPositionModifier();
            StructureModifier dataDirection = packet.getDirections();
            StructureModifier data = packet.getEnumModifier(EnumWrappers.PlayerDigType.class, 2);
            try {
                type = (EnumWrappers.PlayerDigType)data.getValues().get(0);
            }
            catch (IllegalArgumentException exception) {
                type = EnumWrappers.PlayerDigType.SWAP_HELD_ITEMS;
            }
            BlockPosition pos = (BlockPosition)dataTemp.getValues().get(0);
            final World world = player.getWorld();
            final Block block = world.getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            BlockFace blockFace = dataDirection.size() > 0 ? BlockFace.valueOf((String)((EnumWrappers.Direction)dataDirection.read(0)).name()) : BlockFace.UP;
            HardnessModifier triggeredModifier = null;
            for (HardnessModifier modifier : HardnessesManager.getInstance().getAllObjects()) {
                if (!modifier.isEnabled() || !modifier.isTriggered(player, block, item)) continue;
                triggeredModifier = modifier;
                break;
            }
            if (triggeredModifier == null) {
                return;
            }
            long period = triggeredModifier.getPeriod(player, block, item);
            Enchantment enchantment = SCore.is1v20v5Plus() ? Enchantment.EFFICIENCY : Enchantment.getByName((String)"DIG_SPEED");
            switch (item.getEnchantmentLevel(enchantment)) {
                case 0: {
                    break;
                }
                case 1: {
                    period = (long)((double)period * 0.75);
                    break;
                }
                case 2: {
                    period = (long)((double)period * 0.7);
                    break;
                }
                case 3: {
                    period = (long)((double)period * 0.65);
                    break;
                }
                case 4: {
                    period = (long)((double)period * 0.6);
                    break;
                }
                case 5: {
                    period = (long)((double)period * 0.55);
                    break;
                }
                default: {
                    period = (long)((double)period * 0.55);
                }
            }
            final long finalPeriod = period;
            final Location location = block.getLocation();
            final HardnessModifier modifier = triggeredModifier;
            event.setCancelled(true);
            if (finalPeriod <= 0L) {
                Bukkit.getScheduler().runTask((Plugin)SCore.plugin, () -> HardnessesHandler.this.breakBlock(location, world, block, player, item, modifier, null));
            }
            int delay = 20;
            if (modifier.isPeriodInTicks()) {
                delay = 1;
            }
            int delayFinal = delay;
            if (type == EnumWrappers.PlayerDigType.START_DESTROY_BLOCK) {
                Bukkit.getScheduler().runTask((Plugin)SCore.plugin, () -> player.addPotionEffect(new PotionEffect(HardnessesHandler.this.getSlowType(), (int)(finalPeriod * (long)delayFinal) + 1, Integer.MAX_VALUE, false, false, false)));
                if (HardnessesHandler.this.breakerPerLocation.containsKey(location)) {
                    ((BukkitScheduler)HardnessesHandler.this.breakerPerLocation.get(location)).cancelTasks((Plugin)SCore.plugin);
                }
                BukkitScheduler scheduler = Bukkit.getScheduler();
                PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(player, Action.LEFT_CLICK_BLOCK, player.getInventory().getItemInMainHand(), block, blockFace, EquipmentSlot.HAND);
                scheduler.runTask((Plugin)SCore.plugin, () -> Bukkit.getPluginManager().callEvent((Event)playerInteractEvent));
                if (HardnessesHandler.this.blockDamageEventCancelled(block, player)) {
                    return;
                }
                HardnessesHandler.this.breakerPerLocation.put(location, scheduler);
                scheduler.runTaskTimer((Plugin)SCore.plugin, (Consumer)new Consumer<BukkitTask>(){
                    int value = 0;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void accept(BukkitTask bukkitTask) {
                        if (!this.this$1.HardnessesHandler.this.breakerPerLocation.containsKey(location)) {
                            bukkitTask.cancel();
                            return;
                        }
                        for (Entity entity : world.getNearbyEntities(location, 16.0, 16.0, 16.0)) {
                            if (!(entity instanceof Player)) continue;
                            Player viewer = (Player)entity;
                            int stage = (int)((long)(this.value * 10) / finalPeriod);
                            this.this$1.HardnessesHandler.this.sendBlockBreak(viewer, location, stage);
                        }
                        if ((long)this.value++ < finalPeriod) {
                            return;
                        }
                        this.this$1.HardnessesHandler.this.breakBlock(location, world, block, player, item, modifier, bukkitTask);
                    }
                }, 0L, (long)delayFinal);
            } else {
                Bukkit.getScheduler().runTask((Plugin)SCore.plugin, () -> {
                    player.removePotionEffect(HardnessesHandler.this.getSlowType());
                    for (Entity entity : world.getNearbyEntities(location, 16.0, 16.0, 16.0)) {
                        if (!(entity instanceof Player)) continue;
                        Player viewer = (Player)entity;
                        HardnessesHandler.this.sendBlockBreak(viewer, location, 10);
                    }
                    HardnessesHandler.this.breakerPerLocation.remove(location);
                });
            }
        }
    };

    public PotionEffectType getSlowType() {
        return SCore.is1v20v5Plus() ? PotionEffectType.MINING_FATIGUE : PotionEffectType.getByName((String)"SLOW_DIGGING");
    }

    public void breakBlock(Location location, World world, Block block, Player player, ItemStack item, HardnessModifier modifier, BukkitTask bukkitTask) {
        BlockBreakEvent blockBreakEvent = new BlockBreakEvent(block, player);
        Bukkit.getPluginManager().callEvent((Event)blockBreakEvent);
        if (!blockBreakEvent.isCancelled()) {
            modifier.breakBlock(player, block, item);
            PlayerItemDamageEvent playerItemDamageEvent = new PlayerItemDamageEvent(player, item, 1);
            Bukkit.getPluginManager().callEvent((Event)playerItemDamageEvent);
        }
        Bukkit.getScheduler().runTask((Plugin)SCore.plugin, () -> player.removePotionEffect(this.getSlowType()));
        this.breakerPerLocation.remove(location);
        for (Entity entity : world.getNearbyEntities(location, 16.0, 16.0, 16.0)) {
            if (!(entity instanceof Player)) continue;
            Player viewer = (Player)entity;
            this.sendBlockBreak(viewer, location, 10);
        }
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
    }

    public HardnessesHandler() {
        this.protocolManager = SCore.protocolManager;
    }

    private boolean blockDamageEventCancelled(Block block, Player player) {
        return false;
    }

    private void sendBlockBreak(Player player, Location location, int stage) {
        Block block = location.getBlock();
        PacketContainer packet = this.protocolManager.createPacket(PacketType.Play.Server.BLOCK_BREAK_ANIMATION);
        packet.getIntegers().write(0, (Object)location.hashCode()).write(1, (Object)stage);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.toVector()));
        try {
            this.protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerListener() {
        this.protocolManager.addPacketListener((PacketListener)this.listener);
    }

    private String getSound(Block block) {
        return block.getBlockData().getSoundGroup().getHitSound().getKey().toString();
    }
}

