/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.projectiles;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.types.SProjectileTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.SProjectileEditor;
import com.ssomar.score.projectiles.SProjectileEditorManager;
import com.ssomar.score.projectiles.SProjectileType;
import com.ssomar.score.projectiles.SProjectilesEditor;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.projectiles.loader.SProjectileLoader;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SProjectile
extends SObjectWithFileEditable<SProjectile, SProjectileEditor, SProjectileEditorManager> {
    private SProjectileTypeFeature type;
    private List<FeatureAbstract> subFeatures;

    public void transformTheProjectile(Entity e, Player launcher, Material material) {
        if (e instanceof Projectile) {
            for (FeatureAbstract f : this.subFeatures) {
                if (!(f instanceof SProjectileFeatureInterface)) continue;
                ((SProjectileFeatureInterface)((Object)f)).transformTheProjectile(e, launcher, material);
            }
        }
    }

    public SProjectile(FeatureParentInterface parent, String id, String path) {
        super(SCore.plugin, id, parent, FeatureSettingsSCore.SPROJECTILE, path, SProjectileLoader.getInstance());
        this.reset();
    }

    public SProjectile(String id, String path) {
        super(SCore.plugin, id, FeatureSettingsSCore.SPROJECTILE, path, SProjectileLoader.getInstance());
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>(this.type.load(plugin, config, isPremiumLoading));
        this.subFeatures = ((SProjectileType)((Object)((Optional)this.type.getValue()).get())).getFeatures(this);
        for (FeatureAbstract f : this.subFeatures) {
            errors.addAll(f.load(plugin, config, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        for (String s : config.getKeys(false)) {
            config.set(s, null);
        }
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(config);
        }
    }

    @Override
    public SProjectile getValue() {
        return this;
    }

    @Override
    public SProjectile initItemParentEditor(GUI gui, int slot) {
        return null;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public void reset() {
        this.type = new SProjectileTypeFeature(this, Optional.of(SProjectileType.ARROW), FeatureSettingsSCore.type);
        this.subFeatures = ((SProjectileType)((Object)((Optional)this.type.getValue()).get())).getFeatures(this);
    }

    @Override
    public SProjectile clone(FeatureParentInterface newParent) {
        SProjectile clone = new SProjectile(this, this.getId(), this.getPath());
        clone.setType(this.type.clone(clone));
        ArrayList<FeatureAbstract> newFeatures = new ArrayList<FeatureAbstract>();
        for (FeatureAbstract f : this.subFeatures) {
            newFeatures.add((FeatureAbstract)f.clone(clone));
        }
        clone.setSubFeatures(newFeatures);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.type);
        features.addAll(this.subFeatures);
        return features;
    }

    @Override
    public String getParentInfo() {
        return "SProjectile: " + this.getId();
    }

    @Override
    public void reload() {
        if (this.getParent() instanceof SProjectile) {
            SProjectile sProjectile = (SProjectile)this.getParent();
            sProjectile.setType(this.type);
            sProjectile.setSubFeatures(this.subFeatures);
        }
    }

    public void update() {
        ArrayList<FeatureAbstract> newFeatures = new ArrayList<FeatureAbstract>();
        for (FeatureAbstract f : ((SProjectileType)((Object)((Optional)this.type.getValue()).get())).getFeatures(this)) {
            boolean found = false;
            for (FeatureAbstract f2 : this.subFeatures) {
                if (!f2.getName().equals(f.getName())) continue;
                newFeatures.add(f2);
                found = true;
                break;
            }
            if (found) continue;
            newFeatures.add(f);
        }
        this.setSubFeatures(newFeatures);
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, new SProjectilesEditor());
    }

    @Override
    public void openEditor(@NotNull Player player) {
        SProjectileEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public ItemStack getIconItem() {
        return new ItemStack(this.getType().getEditorMaterial());
    }

    @Generated
    public SProjectileTypeFeature getType() {
        return this.type;
    }

    @Generated
    public List<FeatureAbstract> getSubFeatures() {
        return this.subFeatures;
    }

    @Generated
    public void setType(SProjectileTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setSubFeatures(List<FeatureAbstract> subFeatures) {
        this.subFeatures = subFeatures;
    }
}

