/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sparticles;

import com.ssomar.score.SCore;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.CustomColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;

public class SParticle {
    private String id;
    private Particle particlesType;
    private int particlesAmount;
    private double particlesOffSet;
    private double particlesSpeed;
    private int particlesDelay;
    private Color redstoneColor;
    private Material blockType;

    public SParticle(String id) {
        this.id = id;
        this.particlesType = Particle.FLAME;
        this.particlesAmount = 1;
        this.particlesOffSet = 1.0;
        this.particlesSpeed = 1.0;
        this.particlesDelay = 1;
        this.blockType = Material.STONE;
        this.redstoneColor = Color.RED;
    }

    public SParticle(String id, Particle particlesType, int particlesAmount, double particlesOffSet, double particlesSpeed, int particlesDelay) {
        this.id = id;
        this.particlesType = particlesType;
        this.particlesAmount = particlesAmount;
        this.particlesOffSet = particlesOffSet;
        this.particlesSpeed = particlesSpeed;
        this.particlesDelay = particlesDelay;
        this.blockType = Material.STONE;
        this.redstoneColor = Color.RED;
    }

    public static Optional<SParticle> loadSParticle(SPlugin sPlugin, String path, ConfigurationSection conf, String id, boolean showError) {
        Material blockType;
        Color redstoneColor;
        int particlesDelay;
        double particlesSpeed;
        double particlesOffSet;
        int particlesAmount;
        Particle particlesType;
        block13: {
            block12: {
                particlesType = null;
                particlesAmount = 1;
                particlesOffSet = 1.0;
                particlesSpeed = 1.0;
                particlesDelay = 1;
                redstoneColor = null;
                blockType = null;
                if (conf.contains("particlesType")) {
                    try {
                        particlesType = Particle.valueOf((String)conf.getString("particlesType"));
                    }
                    catch (Exception e) {
                        if (showError) {
                            SCore.plugin.getLogger().severe(sPlugin.getNameDesign() + " Error invalid particlesType " + conf.getString("particlesType") + " for the projectile: " + path + " > " + id + " (https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Particle.html)");
                        }
                        return Optional.ofNullable(null);
                    }
                }
                if (particlesType == null) {
                    return Optional.ofNullable(null);
                }
                particlesAmount = conf.getInt("particlesAmount", 1);
                particlesOffSet = conf.getDouble("particlesOffSet", 1.0);
                particlesSpeed = conf.getDouble("particlesSpeed", 1.0);
                particlesDelay = conf.getInt("particlesDelay", 1);
                String redstoneColorStr = conf.getString("redstoneColor", "RED");
                try {
                    redstoneColor = CustomColor.valueOf(redstoneColorStr);
                }
                catch (Exception e) {
                    if (!showError) break block12;
                    SCore.plugin.getLogger().severe(sPlugin.getNameDesign() + " Error invalid redstoneColor " + redstoneColorStr + " for the projectile: " + path + " > " + id + " (https://helpch.at/docs/1.12.2/org/bukkit/Color.html)");
                }
            }
            String blockTypeStr = conf.getString("blockType", "STONE").toUpperCase();
            if (!blockTypeStr.equals("NULL")) {
                try {
                    blockType = Material.valueOf((String)blockTypeStr);
                }
                catch (Exception e) {
                    if (!showError) break block13;
                    SCore.plugin.getLogger().severe(sPlugin.getNameDesign() + " Error invalid blockType " + blockTypeStr + " for the projectile: " + path + " > " + id + " (https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html)");
                }
            }
        }
        SParticle particle = new SParticle(id, particlesType, particlesAmount, particlesOffSet, particlesSpeed, particlesDelay);
        if (redstoneColor != null) {
            particle.setRedstoneColor(redstoneColor);
        }
        if (blockType != null) {
            particle.setBlockType(blockType);
        }
        return Optional.ofNullable(particle);
    }

    public static List<Particle> getHaveBlocktypeParticles() {
        ArrayList<Particle> particles = new ArrayList<Particle>();
        if (SCore.is1v20v5Plus()) {
            particles.add(Particle.BLOCK);
            particles.add(Particle.DUST);
        } else {
            particles.add(Particle.valueOf((String)"BLOCK_CRACK"));
            particles.add(Particle.valueOf((String)"BLOCK_DUST"));
        }
        if (SCore.is1v18Plus()) {
            particles.add(Particle.BLOCK_MARKER);
        }
        return particles;
    }

    public static List<Particle> getHaveRedstoneColorParticles() {
        ArrayList<Particle> particles = new ArrayList<Particle>();
        if (SCore.is1v20v5Plus()) {
            particles.add(Particle.DUST);
        } else {
            particles.add(Particle.valueOf((String)"REDSTONE"));
        }
        return particles;
    }

    public boolean canHaveRedstoneColor() {
        return SParticle.getHaveRedstoneColorParticles().contains(this.getParticlesType());
    }

    public boolean canHaveBlocktype() {
        return SParticle.getHaveBlocktypeParticles().contains(this.particlesType);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Particle getParticlesType() {
        return this.particlesType;
    }

    @Generated
    public int getParticlesAmount() {
        return this.particlesAmount;
    }

    @Generated
    public double getParticlesOffSet() {
        return this.particlesOffSet;
    }

    @Generated
    public double getParticlesSpeed() {
        return this.particlesSpeed;
    }

    @Generated
    public int getParticlesDelay() {
        return this.particlesDelay;
    }

    @Generated
    public Color getRedstoneColor() {
        return this.redstoneColor;
    }

    @Generated
    public Material getBlockType() {
        return this.blockType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setParticlesType(Particle particlesType) {
        this.particlesType = particlesType;
    }

    @Generated
    public void setParticlesAmount(int particlesAmount) {
        this.particlesAmount = particlesAmount;
    }

    @Generated
    public void setParticlesOffSet(double particlesOffSet) {
        this.particlesOffSet = particlesOffSet;
    }

    @Generated
    public void setParticlesSpeed(double particlesSpeed) {
        this.particlesSpeed = particlesSpeed;
    }

    @Generated
    public void setParticlesDelay(int particlesDelay) {
        this.particlesDelay = particlesDelay;
    }

    @Generated
    public void setRedstoneColor(Color redstoneColor) {
        this.redstoneColor = redstoneColor;
    }

    @Generated
    public void setBlockType(Material blockType) {
        this.blockType = blockType;
    }
}

