/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.utils.safeplace.SafePlace;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropsGrowthBoost
extends BlockCommand {
    @Override
    public void run(final @Nullable Player p, final @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final int radius = Double.valueOf(args.get(0)).intValue();
        final int delay = Double.valueOf(args.get(1)).intValue();
        final int duration = Double.valueOf(args.get(2)).intValue();
        int chance = Double.valueOf(args.get(3)).intValue();
        if (chance > 100) {
            chance = 100;
        }
        if (chance < 0) {
            chance = 0;
        }
        final int finalChance = chance;
        final int[] i = new int[]{0};
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (i[0] >= duration) {
                    ((ScheduledTask)task.get()).cancel();
                } else {
                    CropsGrowthBoost.this.grownAgeableBlocks(block.getLocation(), radius, finalChance, p);
                    i[0] = i[0] + delay;
                }
            }
        };
        task.set(SCore.schedulerHook.runRepeatingTask(runnable3, 0L, delay));
    }

    public void grownAgeableBlocks(Location start, int radius, int finalChance, Player receiver) {
        for (double x = start.getX() - (double)radius; x <= start.getX() + (double)radius; x += 1.0) {
            for (double y = start.getY() - (double)radius; y <= start.getY() + (double)radius; y += 1.0) {
                for (double z = start.getZ() - (double)radius; z <= start.getZ() + (double)radius; z += 1.0) {
                    Ageable ageable;
                    int random;
                    Location loc = new Location(start.getWorld(), x, y, z);
                    Block block = loc.getBlock();
                    BlockData data = block.getBlockData();
                    if (!(data instanceof Ageable) || (random = new Random().nextInt(100)) > finalChance || receiver != null && !receiver.isOp() && !SafePlace.verifSafePlace(receiver.getUniqueId(), block) || (ageable = (Ageable)data).getAge() >= ageable.getMaximumAge()) continue;
                    ageable.setAge(ageable.getAge() + 1);
                    block.setBlockData((BlockData)ageable);
                }
            }
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 4) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        for (String arg : args) {
            ArgumentChecker ac = CropsGrowthBoost.checkInteger(arg, isFinalVerification, this.getTemplate());
            if (ac.isValid()) continue;
            return Optional.of(ac.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("CROPS_GROWTH_BOOST");
        return names;
    }

    @Override
    public String getTemplate() {
        return "CROPS_GROWTH_BOOST {radius} {delay between two growths in ticks} {total duration in ticks} {chance 0-100}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

