/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AddItemlore
extends PlayerCommand {
    public AddItemlore() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)0);
        slot.setSlot(true);
        CommandSetting text = new CommandSetting("text", 1, String.class, (Object)"New lore");
        text.setAcceptUnderScoreForLongText(true);
        CommandSetting insertIndex = new CommandSetting("insertIndex", -1, Integer.class, (Object)-1);
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(text);
        settings.add(insertIndex);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        ItemMeta itemmeta;
        ArrayList<String> list;
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        int insertIndex = (Integer)sCommandToExec.getSettingValue("insertIndex");
        String text = (String)sCommandToExec.getSettingValue("text");
        List<String> args = sCommandToExec.getOtherArgs();
        StringBuilder message = new StringBuilder(text);
        message.append(" ");
        for (String s : args) {
            message.append(s).append(" ");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        if ((list = (ArrayList<String>)(itemmeta = item.getItemMeta()).getLore()) == null) {
            list = new ArrayList<String>();
        }
        if (!message.toString().isEmpty()) {
            if (insertIndex == -1) {
                list.add(StringConverter.coloredString(message.toString()));
            } else {
                list.add(insertIndex, StringConverter.coloredString(message.toString()));
            }
        }
        itemmeta.setLore(list);
        item.setItemMeta(itemmeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ADD_ITEM_LORE");
        names.add("ADD_LORE");
        names.add("ADDLORE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "ADD_ITEM_LORE slot:-1 text:My_new_lore_line insertIndex:0";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

