/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommmandThatRunsCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.features.custom.conditions.placeholders.placeholder.PlaceholderConditionFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.ComparatorFeature;
import com.ssomar.score.features.types.PlaceholderConditionTypeFeature;
import com.ssomar.score.utils.emums.Comparator;
import com.ssomar.score.utils.emums.PlaceholdersCdtType;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class If
extends PlayerCommand {
    public If() {
        this.setCanExecuteCommands(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        List<String> args = sCommandToExec.getOtherArgs();
        String condition = args.get(0);
        SsomarDev.testMsg("IF condition: " + condition, true);
        StringPlaceholder sp = aInfo.getSp();
        if (sp == null) {
            sp = new StringPlaceholder();
        }
        sp.setPlayerPlcHldr(receiver.getUniqueId(), aInfo.getSlot());
        sp.reloadAllPlaceholders();
        ArrayList<Player> targets = new ArrayList<Player>();
        targets.add(receiver);
        boolean finalResult = this.evaluateCondition(condition, receiver, sp);
        if (finalResult) {
            CommmandThatRunsCommand.runPlayerCommands(targets, args.subList(1, args.size()), aInfo);
        } else {
            SsomarDev.testMsg("IF STOPPED for condition > " + condition, true);
        }
    }

    private boolean evaluateCondition(String condition, Player receiver, StringPlaceholder sp) {
        condition = condition.replaceAll("\\s+", "");
        condition = StringConverter.deconvertColor(condition);
        Stack<Boolean> values = new Stack<Boolean>();
        Stack<Character> operators = new Stack<Character>();
        for (int i = 0; i < condition.length(); ++i) {
            char ch = condition.charAt(i);
            if (ch == '(') {
                operators.push(Character.valueOf(ch));
                continue;
            }
            if (ch == ')') {
                while (((Character)operators.peek()).charValue() != '(') {
                    values.push(this.applyOperator(((Character)operators.pop()).charValue(), (Boolean)values.pop(), (Boolean)values.pop()));
                }
                operators.pop();
                continue;
            }
            if (ch == '&' || ch == '|') {
                char operator;
                if (i + 1 >= condition.length() || condition.charAt(i + 1) != ch) continue;
                char c = operator = ch == '&' ? (char)'&' : '|';
                while (!operators.isEmpty() && this.hasPrecedence(operator, ((Character)operators.peek()).charValue())) {
                    values.push(this.applyOperator(((Character)operators.pop()).charValue(), (Boolean)values.pop(), (Boolean)values.pop()));
                }
                operators.push(Character.valueOf(operator));
                ++i;
                continue;
            }
            StringBuilder cond = new StringBuilder();
            while (i < condition.length() && condition.charAt(i) != '(' && condition.charAt(i) != ')' && condition.charAt(i) != '&' && condition.charAt(i) != '|') {
                cond.append(condition.charAt(i));
                ++i;
            }
            --i;
            boolean result = this.evaluateSingleCondition(cond.toString(), receiver, sp);
            values.push(result);
        }
        while (!operators.isEmpty()) {
            values.push(this.applyOperator(((Character)operators.pop()).charValue(), (Boolean)values.pop(), (Boolean)values.pop()));
        }
        return (Boolean)values.pop();
    }

    private boolean applyOperator(char operator, boolean b1, boolean b2) {
        if (operator == '&') {
            return b1 && b2;
        }
        if (operator == '|') {
            return b1 || b2;
        }
        throw new IllegalArgumentException("Invalid operator: " + operator);
    }

    private boolean hasPrecedence(char op1, char op2) {
        if (op2 == '(' || op2 == ')') {
            return false;
        }
        return op1 != '&' || op2 != '|';
    }

    private boolean evaluateSingleCondition(String condition, Player receiver, StringPlaceholder sp) {
        PlaceholderConditionFeature conditionFeature = PlaceholderConditionFeature.buildNull();
        conditionFeature.setType(PlaceholderConditionTypeFeature.buildNull(PlaceholdersCdtType.PLAYER_PLAYER));
        boolean conditionContainsPlaceholder = condition.contains("%");
        String split = conditionContainsPlaceholder ? "%" : "";
        Comparator comparator = null;
        for (Comparator c : Comparator.values()) {
            if (!condition.contains(split + c.getSymbol())) continue;
            conditionFeature.setComparator(ComparatorFeature.buildNull(c));
            comparator = c;
            break;
        }
        if (comparator == null) {
            SsomarDev.testMsg("IF STOPPED because comparator null for condition: " + condition, true);
            return false;
        }
        String[] parts = condition.split(split + comparator.getSymbol());
        if (parts.length < 2) {
            SsomarDev.testMsg("IF STOPPED because parts are invalid for condition: " + condition, true);
            return false;
        }
        String part1 = parts[0].trim() + split;
        String part2 = parts[1].trim();
        conditionFeature.setPart1(ColoredStringFeature.buildNull(part1));
        conditionFeature.setPart2(ColoredStringFeature.buildNull(part2));
        return conditionFeature.verify(receiver, null, sp);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 2) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("IF");
        return names;
    }

    @Override
    public String getTemplate() {
        return "IF {condition_without_spaces} {command1} <+> {command2} <+> ...";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

