/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.logging.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UsePerDayQuery {
    public static final Boolean DEBUG = false;
    private static final String TABLE_USE_PER_DAY = "useperday";
    private static final String TABLE_USE_PER_DAY_NAME = "UsePerDay";
    private static final String COL_DATE = "date";
    private static final String COL_PLAYER = "player";
    private static final String COL_ID = "id";
    private static final String COL_NB = "nb";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS useperday (date TEXT NOT NULL, player TEXT NOT NULL, id TEXT NOT NULL, nb INTEGER NOT NULL);";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("UsePerDayQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6UsePerDay &7if not exists...");
            stmt.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe(e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertPlayerUserPerDay(Connection conn, Map<String, Map<String, Map<String, Integer>>> map) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("UsePerDayQuery insertPlayerUserPerDay");
        }
        UsePerDayQuery.purgeUserPerDay(conn);
        String sql = "INSERT INTO useperday (date,player, id, nb) VALUES(?, ?, ?, ?)";
        PreparedStatement pstmt = null;
        Date today = new Date();
        SimpleDateFormat formater = new SimpleDateFormat("dd-MM-yy");
        String date = formater.format(today);
        int i = 0;
        if (!map.containsKey(date)) {
            return true;
        }
        try {
            pstmt = conn.prepareStatement(sql);
            for (String player : map.get(date).keySet()) {
                ++i;
                for (String item : map.get(date).get(player).keySet()) {
                    int nb = map.get(date).get(player).get(item);
                    pstmt.setString(1, date);
                    pstmt.setString(2, player);
                    pstmt.setString(3, item);
                    pstmt.setInt(4, nb);
                    pstmt.addBatch();
                }
                if (i % 15 != 0 && i != map.size()) continue;
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeUserPerDay(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("UsePerDayQuery purgeUserPerDay");
        }
        String sql = "DELETE FROM useperday";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe(e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, Map<String, Integer>>> loadUsePerDay(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("UsePerDayQuery loadUsePerDay");
        }
        String sql = "SELECT * FROM useperday where date=?";
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        HashMap<String, Map<String, Map<String, Integer>>> map = new HashMap<String, Map<String, Map<String, Integer>>>();
        HashMap<String, Map<String, Integer>> datas = new HashMap<String, Map<String, Integer>>();
        Date today = new Date();
        SimpleDateFormat formater = new SimpleDateFormat("dd-MM-yy");
        String date = formater.format(today);
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, date);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Map<String, Integer> map2;
                String player = rs.getString(COL_PLAYER);
                String item = rs.getString(COL_ID);
                int nb = rs.getInt(COL_NB);
                if (datas.containsKey(player)) {
                    map2 = (Map)datas.get(player);
                    if (map2.containsKey(item)) {
                        map2.put(item, (Integer)map2.get(item) + nb);
                        continue;
                    }
                    map2.put(item, nb);
                    continue;
                }
                map2 = new HashMap();
                map2.put(item, nb);
                datas.put(player, map2);
            }
            map.put(date, datas);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }
}

