/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.editor;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewInteractionClickedGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.menu.commands.CommandsEditor;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.messages.CenteredMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class NewGUIManager<T extends GUI> {
    public HashMap<Player, T> cache = new HashMap();
    public HashMap<Player, String> requestWriting = new HashMap();
    public HashMap<Player, List<String>> currentWriting = new HashMap();
    public Map<Player, Boolean> activeTextEditor;
    public List<TextComponent> moreInfo = new ArrayList<TextComponent>();
    public Map<Player, List<Suggestion>> suggestions = new HashMap<Player, List<Suggestion>>();
    public Map<Player, Integer> suggestionPage = new HashMap<Player, Integer>();
    private int suggestionsPerColumn = 12;

    public NewGUIManager() {
        this.activeTextEditor = new HashMap<Player, Boolean>();
    }

    public void reload() {
        this.cache = new HashMap();
        this.requestWriting = new HashMap();
        this.currentWriting = new HashMap();
        this.moreInfo = new ArrayList<TextComponent>();
        this.suggestions = new HashMap<Player, List<Suggestion>>();
        this.suggestionsPerColumn = 12;
        this.suggestionPage = new HashMap<Player, Integer>();
        this.activeTextEditor = new HashMap<Player, Boolean>();
    }

    public void enableTextEditor(Player player) {
        this.activeTextEditor.put(player, true);
        this.suggestionPage.put(player, 0);
    }

    public void disableTextEditor(Player player) {
        this.activeTextEditor.remove(player);
        this.suggestionPage.remove(player);
    }

    public void clicked(Player p, ItemStack item, ClickType click) {
        NewInteractionClickedGUIManager interact = new NewInteractionClickedGUIManager();
        interact.player = p;
        this.clicked(item, interact, click);
    }

    public void clicked(ItemStack item, NewInteractionClickedGUIManager<T> interact, ClickType click) {
        if (item != null && item.hasItemMeta()) {
            interact.cache = this.getCache();
            interact.setName(GUI.getIdentifier(item));
            DynamicMeta meta = new DynamicMeta(item.getItemMeta());
            Optional<String> folderInfoOpt = ItemKeyWriterReader.init().readString(SCore.pluginHolder, item, meta, "folderInfo");
            if (folderInfoOpt.isPresent()) {
                interact.localizedName = folderInfoOpt.get();
            } else if (!SCore.is1v11Less() && item.getItemMeta().hasLocalizedName()) {
                interact.localizedName = item.getItemMeta().getLocalizedName();
            }
            interact.gui = (GUI)this.cache.get(interact.player);
            if (interact.coloredDeconvertName.equals(GUI.RESET)) {
                this.reset(interact);
            } else if (interact.coloredDeconvertName.equals(GUI.CHANGE_LANGUAGE)) {
                if (click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.LEFT)) {
                    this.nextLang(interact);
                } else if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.RIGHT)) {
                    this.previousLang(interact);
                }
            } else if (interact.coloredDeconvertName.equals(GUI.BACK)) {
                this.back(interact);
            } else if (interact.coloredDeconvertName.equals(GUI.NEW)) {
                this.newObject(interact);
            } else if (interact.coloredDeconvertName.equals(GUI.EXIT)) {
                interact.player.closeInventory();
            } else if (interact.coloredDeconvertName.equals(GUI.SAVE) || interact.coloredDeconvertName.equals(TM.g(Text.EDITOR_SAVE_NAME))) {
                this.save(interact);
                this.back(interact);
            } else if (interact.coloredDeconvertName.equals(GUI.REMOVE)) {
                this.remove(interact);
            } else if (interact.coloredDeconvertName.equals(GUI.NEXT_PAGE)) {
                this.nextPage(interact);
            } else if (interact.coloredDeconvertName.equals(GUI.PREVIOUS_PAGE)) {
                this.previousPage(interact);
            } else {
                if (click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.SHIFT_RIGHT)) {
                    if (click.equals((Object)ClickType.SHIFT_LEFT) ? this.shiftLeftClicked(interact) : this.shiftRightClicked(interact)) {
                        return;
                    }
                    if (this.shiftClicked(interact)) {
                        return;
                    }
                } else {
                    if (click.equals((Object)ClickType.RIGHT) ? this.noShiftRightclicked(interact) : click.equals((Object)ClickType.LEFT) && this.noShiftLeftclicked(interact)) {
                        return;
                    }
                    if (this.noShiftclicked(interact)) {
                        return;
                    }
                }
                if (click.equals((Object)ClickType.RIGHT) ? this.rightClicked(interact) : (click.equals((Object)ClickType.LEFT) ? this.leftClicked(interact) : (click.equals((Object)ClickType.MIDDLE) ? this.middleClicked(interact) : click.equals((Object)ClickType.DOUBLE_CLICK) && this.doubleClicked(interact)))) {
                    return;
                }
                if (this.allClicked(interact)) {
                    return;
                }
            }
        }
    }

    public abstract boolean allClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean noShiftclicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean noShiftLeftclicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean noShiftRightclicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean shiftClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean shiftLeftClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean shiftRightClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean leftClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean rightClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean middleClicked(NewInteractionClickedGUIManager<T> var1);

    public abstract boolean doubleClicked(NewInteractionClickedGUIManager<T> var1);

    public void receiveMessage(Player p, String message) {
        NewInteractionClickedGUIManager interact = new NewInteractionClickedGUIManager();
        interact.player = p;
        interact.setMessage(message);
        interact.gui = (GUI)this.cache.get(interact.player);
        this.receiveMessage(interact);
    }

    public void receiveMessage(NewInteractionClickedGUIManager<T> interact) {
        String message = interact.decoloredMessage;
        boolean pass = false;
        if (!CommandsEditor.getInstance().isAsking(interact.player)) {
            if (message.equals("PREVIOUS PAGE")) {
                this.receiveMessagePreviousPage(interact);
                pass = true;
            } else if (message.equals("NEXT PAGE")) {
                this.receiveMessageNextPage(interact);
                pass = true;
            } else if (message.contains("delete line <")) {
                this.receiveMessageDeleteline(interact);
                pass = true;
            } else if (message.contains("up line <")) {
                this.receiveMessageUpLine(interact);
                pass = true;
            } else if (message.contains("down line <")) {
                this.receiveMessageDownLine(interact);
                pass = true;
            } else if (message.contains("edit line <")) {
                this.receiveMessageEditLine(interact);
                pass = true;
            } else if (message.contains("NO VALUE / EXIT")) {
                this.receiveMessageNoValue(interact);
                pass = true;
            }
        }
        if (message.equals("exit")) {
            this.receiveMessageFinish(interact);
            pass = true;
        }
        if (!pass) {
            this.receiveMessageValue(interact);
        }
    }

    public void receiveMessagePreviousPage(NewInteractionClickedGUIManager<T> interact) {
        this.suggestionPage.put(interact.player, this.suggestionPage.get(interact.player) - 1);
    }

    public void receiveMessageNextPage(NewInteractionClickedGUIManager<T> interact) {
        this.suggestionPage.put(interact.player, this.suggestionPage.get(interact.player) + 1);
    }

    public abstract void receiveMessageNoValue(NewInteractionClickedGUIManager<T> var1);

    public abstract void receiveMessageFinish(NewInteractionClickedGUIManager<T> var1);

    public void receiveMessageDeleteline(NewInteractionClickedGUIManager<T> interact) {
        Player p = interact.player;
        this.space(p);
        this.space(p);
        int line = Integer.parseInt(interact.decoloredMessage.split("delete line <")[1].split(">")[0]);
        this.currentWriting.get(p).remove(line);
        p.sendMessage(StringConverter.coloredString("&a&l>> &2&lEDITION &aYou have delete the line: " + line + " !"));
        this.space(p);
        this.space(p);
    }

    public void receiveMessageUpLine(NewInteractionClickedGUIManager<T> interact) {
        Player p = interact.player;
        this.space(p);
        this.space(p);
        int line = Integer.valueOf(interact.decoloredMessage.split("up line <")[1].split(">")[0]);
        if (line != 0) {
            String current = this.currentWriting.get(p).get(line);
            this.currentWriting.get(p).set(line, this.currentWriting.get(p).get(line - 1));
            this.currentWriting.get(p).set(line - 1, current);
        }
        p.sendMessage(StringConverter.coloredString("&a&l>> &2&lEDITION &aYou have up the line: " + line + " to " + (line - 1) + " !"));
        this.space(p);
        this.space(p);
    }

    public void receiveMessageDownLine(NewInteractionClickedGUIManager<T> interact) {
        Player p = interact.player;
        this.space(p);
        this.space(p);
        int line = Integer.valueOf(interact.decoloredMessage.split("down line <")[1].split(">")[0]);
        if (this.currentWriting.containsKey(p) && this.currentWriting.get(p).size() - 1 > line) {
            String current = this.currentWriting.get(p).get(line);
            this.currentWriting.get(p).set(line, this.currentWriting.get(p).get(line + 1));
            this.currentWriting.get(p).set(line + 1, current);
        }
        p.sendMessage(StringConverter.coloredString("&a&l>> &2&lEDITION &aYou have down the line: " + line + " to " + (line + 1) + " !"));
        this.space(p);
        this.space(p);
    }

    public void receiveMessageEditLine(NewInteractionClickedGUIManager<T> interact) {
        Player p = interact.player;
        if (this.currentWriting.get(p).size() == 0) {
            return;
        }
        this.space(p);
        this.space(p);
        int line = Integer.valueOf(interact.decoloredMessage.split("edit line <")[1].split(">")[0]);
        if (line >= 0) {
            String modification = interact.coloredDeconvertMessage.split("edit line <" + line + "> ->")[1];
            this.currentWriting.get(p).set(line, modification);
        }
        p.sendMessage(StringConverter.coloredString("&a&l>> &2&lEDITION &aYou have edit the line: " + line + " !"));
        this.space(p);
        this.space(p);
    }

    public abstract void receiveMessageValue(NewInteractionClickedGUIManager<T> var1);

    public abstract void newObject(NewInteractionClickedGUIManager<T> var1);

    public abstract void reset(NewInteractionClickedGUIManager<T> var1);

    public void nextLang(NewInteractionClickedGUIManager<T> interact) {
        GeneralConfig.getInstance().nextLocale();
        ((GUI)interact.gui).fullReloadAndReopen(interact.player);
    }

    public void previousLang(NewInteractionClickedGUIManager<T> interact) {
        GeneralConfig.getInstance().previousLocale();
        ((GUI)interact.gui).fullReloadAndReopen(interact.player);
    }

    public abstract void back(NewInteractionClickedGUIManager<T> var1);

    public abstract void nextPage(NewInteractionClickedGUIManager<T> var1);

    public abstract void previousPage(NewInteractionClickedGUIManager<T> var1);

    public abstract void save(NewInteractionClickedGUIManager<T> var1);

    public void remove(NewInteractionClickedGUIManager<T> interact) {
    }

    public void showCalculationGUI(Player p, String variable, String current) {
        p.sendMessage(StringConverter.coloredString("&8\u27a4 &7&oReplace {number} by the number of your choice !"));
        TextComponent message = new TextComponent(StringConverter.coloredString("&8\u27a4 &7Choose an option: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, current));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current condition")).create()));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(StringConverter.coloredString(" &7Or create new condition: ")));
        TextComponent inf = new TextComponent(StringConverter.coloredString("&a&l[<]"));
        inf.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "<{number}"));
        inf.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick to add condition " + variable + " < {number}")).create()));
        TextComponent infE = new TextComponent(StringConverter.coloredString("&a&l[<=]"));
        infE.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "<={number}"));
        infE.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick to add condition " + variable + " <= {number}")).create()));
        TextComponent egal = new TextComponent(StringConverter.coloredString("&a&l[==]"));
        egal.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "=={number}"));
        egal.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick to add condition " + variable + " == {number}")).create()));
        TextComponent sup = new TextComponent(StringConverter.coloredString("&a&l[>]"));
        sup.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ">{number}"));
        sup.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick to add condition " + variable + " > {number}")).create()));
        TextComponent supE = new TextComponent(StringConverter.coloredString("&a&l[>=]"));
        supE.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ">={number}"));
        supE.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick to add condition " + variable + " >= {number}")).create()));
        TextComponent noC = new TextComponent(StringConverter.coloredString("&c&l[NO CONDITION]"));
        noC.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "exit with delete"));
        noC.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick to don't set condition")).create()));
        message.addExtra((BaseComponent)inf);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)infE);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)egal);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)sup);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)supE);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noC);
        p.spigot().sendMessage((BaseComponent)message);
    }

    public void deleteLine(String message, Player p) {
        this.space(p);
        this.space(p);
        int line = Integer.parseInt(message.split("delete line <")[1].split(">")[0]);
        this.deleteLine(p, line);
        p.sendMessage(StringConverter.coloredString("&a&l>> &2&lEDITION &aYou have delete the line: " + line + " !"));
        this.space(p);
        this.space(p);
    }

    public void deleteLine(Player p, int nb) {
        if (this.currentWriting.containsKey(p)) {
            this.currentWriting.get(p).remove(nb);
        }
    }

    public void editLine(Player p, int nb, String edition) {
        if (this.currentWriting.containsKey(p)) {
            if (nb >= this.currentWriting.get(p).size()) {
                this.currentWriting.get(p).add(edition);
            } else {
                this.currentWriting.get(p).set(nb, edition);
            }
        }
    }

    public void space(Player p) {
        p.sendMessage("");
    }

    public String getStringBeforeEnd(String insert) {
        StringBuilder sb = new StringBuilder();
        for (char c : insert.toCharArray()) {
            if (c == ',' || c == '}') {
                return sb.toString();
            }
            sb.append(c);
        }
        return "";
    }

    public void sendEditor(@NotNull Player p, String tips) {
        this.sendSuggestions(p, tips);
    }

    public void sendSuggestions(Player p, String tips) {
        String changementPage;
        this.space(p);
        if (this.moreInfo != null) {
            for (TextComponent tc : this.moreInfo) {
                p.spigot().sendMessage((BaseComponent)tc);
            }
        }
        if (this.suggestions.get(p).size() > 0) {
            p.sendMessage(StringConverter.coloredString("&5&o>> &dChoose a suggestion below:"));
            this.space(p);
        }
        ArrayList<TextComponent> listCommands = new ArrayList<TextComponent>();
        int y = this.suggestionPage.get(p) * this.suggestionsPerColumn;
        while (y < (this.suggestionPage.get(p) + 1) * this.suggestionsPerColumn && this.suggestions.get(p).size() - 1 >= y) {
            Suggestion suggestion = this.suggestions.get(p).get(y);
            TextComponent cmd1Cpnt = new TextComponent("");
            TextComponent cmd1WikiCpnt = new TextComponent("");
            TextComponent cmd2Cpnt = new TextComponent("");
            TextComponent cmd2WikiCpnt = new TextComponent("");
            String commandStr1 = StringConverter.coloredString(suggestion.getSuggestionDisplay());
            String commandStr2 = " ";
            cmd1Cpnt.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestion.getSuggestion()));
            cmd1Cpnt.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString(suggestion.getSuggestionHover())).create()));
            if (suggestion.getWikiLink() != null) {
                cmd1WikiCpnt.setText(StringConverter.coloredString("&e&o[Wiki]"));
                cmd1WikiCpnt.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, suggestion.getWikiLink()));
                cmd1WikiCpnt.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&7&oClick here to see the wiki")).create()));
            }
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            if (y + 1 != this.suggestions.get(p).size()) {
                Suggestion suggestion2 = this.suggestions.get(p).get(y + 1);
                if (suggestion2.getWikiLink() != null) {
                    cmd2WikiCpnt.setText(StringConverter.coloredString("&e&o[Wiki]"));
                    cmd2WikiCpnt.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, suggestion2.getWikiLink()));
                    cmd2WikiCpnt.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&7&oClick here to see the wiki")).create()));
                }
                commandStr2 = StringConverter.coloredString(suggestion2.getSuggestionDisplay());
                int charDiff = commandStr1.length() - commandStr2.length();
                while (charDiff != 0) {
                    if (charDiff > 0) {
                        after.append(" ");
                        --charDiff;
                        continue;
                    }
                    before.append(" ");
                    ++charDiff;
                }
                cmd2Cpnt.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestion2.getSuggestion()));
                cmd2Cpnt.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString(suggestion2.getSuggestionHover())).create()));
                y += 2;
            } else {
                ++y;
            }
            String commandsStr = before + cmd1WikiCpnt.getText() + " |" + commandStr1 + "     |     " + commandStr2 + "| " + cmd2WikiCpnt.getText() + after;
            commandsStr = CenteredMessage.convertIntoCenteredMessage(commandsStr);
            cmd1WikiCpnt.setText(commandsStr.split("\\|")[0]);
            cmd1Cpnt.setText(commandsStr.split("\\|")[1]);
            cmd2Cpnt.setText(commandsStr.split("\\|")[2]);
            cmd2WikiCpnt.setText(commandsStr.split("\\|")[3]);
            cmd1WikiCpnt.addExtra((BaseComponent)cmd1Cpnt);
            cmd1WikiCpnt.addExtra((BaseComponent)cmd2Cpnt);
            cmd1WikiCpnt.addExtra((BaseComponent)cmd2WikiCpnt);
            listCommands.add(cmd1WikiCpnt);
        }
        for (int i = 0; i < listCommands.size(); ++i) {
            p.spigot().sendMessage((BaseComponent)listCommands.get(i));
        }
        if (!tips.isEmpty()) {
            CenteredMessage.sendCenteredMessage(p, tips);
            this.space(p);
        }
        boolean noSend = false;
        if (this.suggestionPage.get(p) == 0) {
            if (this.suggestions.get(p).size() > this.suggestionsPerColumn) {
                changementPage = " | &d&lNext page &5&l>>>>>";
            } else {
                changementPage = " | ";
                noSend = true;
            }
        } else {
            changementPage = (this.suggestionPage.get(p) + 1) * this.suggestionsPerColumn > this.suggestions.get(p).size() ? "&5&l<<<<< &d&lPrevious page | " : "&5&l<<<<< &d&lPrevious page | &d&lNext page &5&l>>>>>";
        }
        changementPage = CenteredMessage.convertIntoCenteredMessage(changementPage);
        String previousStr = changementPage.split("\\|")[0];
        String nextStr = changementPage.split("\\|")[1];
        TextComponent previousText = new TextComponent(previousStr);
        previousText.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact PREVIOUS PAGE"));
        previousText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&5&l<<<<< &d&lPrevious page")).create()));
        TextComponent nextText = new TextComponent(nextStr);
        nextText.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NEXT PAGE"));
        nextText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&d&lNext page &5&l>>>>>")).create()));
        previousText.addExtra((BaseComponent)nextText);
        if (!noSend) {
            p.spigot().sendMessage((BaseComponent)previousText);
        }
        this.space(p);
    }

    @Generated
    public HashMap<Player, T> getCache() {
        return this.cache;
    }

    @Generated
    public HashMap<Player, String> getRequestWriting() {
        return this.requestWriting;
    }

    @Generated
    public HashMap<Player, List<String>> getCurrentWriting() {
        return this.currentWriting;
    }

    @Generated
    public Map<Player, Boolean> getActiveTextEditor() {
        return this.activeTextEditor;
    }

    @Generated
    public List<TextComponent> getMoreInfo() {
        return this.moreInfo;
    }

    @Generated
    public Map<Player, List<Suggestion>> getSuggestions() {
        return this.suggestions;
    }

    @Generated
    public Map<Player, Integer> getSuggestionPage() {
        return this.suggestionPage;
    }

    @Generated
    public int getSuggestionsPerColumn() {
        return this.suggestionsPerColumn;
    }
}

