/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.events;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.Couple;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class NoFallDamageListener
implements Listener {
    private static NoFallDamageListener instance;
    private final Map<UUID, List<Couple<UUID, ScheduledTask>>> noFallDamageMap = new HashMap<UUID, List<Couple<UUID, ScheduledTask>>>();

    @EventHandler
    public void onEntityDamageEvent(EntityDamageEvent e) {
        if (!e.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL) || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        NoFallDamageListener nFD = NoFallDamageListener.getInstance();
        if (nFD.contains((Entity)p)) {
            e.setCancelled(true);
            nFD.removeAllNoFallDamage((Entity)p);
        }
    }

    public static NoFallDamageListener getInstance() {
        if (instance == null) {
            instance = new NoFallDamageListener();
        }
        return instance;
    }

    public void addNoFallDamage(final Entity e) {
        final UUID uuid = UUID.randomUUID();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NoFallDamageListener.getInstance().removeNoFallDamage(e, uuid);
            }
        };
        ScheduledTask task = SCore.schedulerHook.runTask(runnable, 300L);
        NoFallDamageListener.getInstance().addNoFallDamage(e, new Couple<UUID, ScheduledTask>(uuid, task));
    }

    public void addNoFallDamage(Entity e, Couple<UUID, ScheduledTask> c) {
        if (this.noFallDamageMap.containsKey(e.getUniqueId())) {
            this.noFallDamageMap.get(e.getUniqueId()).add(c);
        } else {
            ArrayList<Couple<UUID, ScheduledTask>> newList = new ArrayList<Couple<UUID, ScheduledTask>>();
            newList.add(c);
            this.noFallDamageMap.put(e.getUniqueId(), newList);
        }
    }

    public void removeNoFallDamage(Entity e, UUID uuid) {
        boolean emptyList = false;
        for (UUID eUUID : this.noFallDamageMap.keySet()) {
            if (e.getUniqueId() != eUUID) continue;
            List<Couple<UUID, ScheduledTask>> tasks = this.noFallDamageMap.get(e.getUniqueId());
            Couple<UUID, ScheduledTask> toRemove = null;
            for (Couple<UUID, ScheduledTask> c : tasks) {
                if (!c.getElem1().equals(uuid)) continue;
                c.getElem2().cancel();
                toRemove = c;
            }
            if (toRemove != null) {
                tasks.remove(toRemove);
            }
            emptyList = tasks.size() == 0;
            break;
        }
        if (emptyList) {
            this.noFallDamageMap.remove(e.getUniqueId());
        }
    }

    public void removeAllNoFallDamage(Entity e) {
        this.noFallDamageMap.remove(e);
    }

    public boolean contains(Entity e) {
        for (UUID eUUID : this.noFallDamageMap.keySet()) {
            if (e.getUniqueId() != eUUID) continue;
            return true;
        }
        return false;
    }
}

