/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.block.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.block.BlockConditionFeature;
import com.ssomar.score.features.custom.conditions.block.BlockConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;

public class IfBlockAge
extends BlockConditionFeature<NumberConditionFeature, IfBlockAge> {
    public IfBlockAge(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifBlockAge);
    }

    @Override
    public IfBlockAge getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifBlockAge));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfBlockAge getNewInstance(FeatureParentInterface parent) {
        return new IfBlockAge(parent);
    }

    @Override
    public boolean verifCondition(BlockConditionRequest request) {
        Optional<Player> playerOpt = request.getPlayerOpt();
        Block b = request.getBlock();
        if (b.getState().getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)b.getState().getBlockData();
            int age = ageable.getAge();
            if (this.hasCondition() && !StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(playerOpt, request.getSp()).get(), age)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }
}

