/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.enchantments.enchantment;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.EnchantmentFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EnchantmentWithLevelFeature
extends FeatureWithHisOwnEditor<EnchantmentWithLevelFeature, EnchantmentWithLevelFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private EnchantmentFeature enchantment;
    private IntegerFeature level;
    private String id;

    public EnchantmentWithLevelFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.enchantmentWithLevel);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.enchantment = new EnchantmentFeature(this, Optional.of(EnchantmentWithLevelFeature.getDefaultEnchantment()), FeatureSettingsSCore.enchantment);
        this.level = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.level);
    }

    public static Enchantment getDefaultEnchantment() {
        return SCore.is1v20v5Plus() ? Enchantment.UNBREAKING : Enchantment.getByName((String)"DURABILITY");
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.enchantment.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.level.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Enchantment with level value because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection enchantmentConfig = config.createSection(this.id);
        this.enchantment.save(enchantmentConfig);
        this.level.save(enchantmentConfig);
    }

    @Override
    public EnchantmentWithLevelFeature getValue() {
        return this;
    }

    @Override
    public EnchantmentWithLevelFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = "&7Enchantment: &e" + this.enchantment.getEnchantmentName((Enchantment)((Optional)this.enchantment.getValue()).get());
        finalDescription[finalDescription.length - 3] = "&7Level: &e" + ((Optional)this.level.getValue()).get();
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = GUI.SHIFT_CLICK_TO_REMOVE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public EnchantmentWithLevelFeature clone(FeatureParentInterface newParent) {
        EnchantmentWithLevelFeature eF = new EnchantmentWithLevelFeature(newParent, this.id);
        eF.setEnchantment(this.enchantment.clone(eF));
        eF.setLevel(this.level.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.enchantment, this.level));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            EnchantmentWithLevelFeature eF;
            if (!(feature instanceof EnchantmentWithLevelFeature) || !(eF = (EnchantmentWithLevelFeature)feature).getId().equals(this.id)) continue;
            eF.setEnchantment(this.enchantment);
            eF.setLevel(this.level);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public EnchantmentFeature getEnchantment() {
        return this.enchantment;
    }

    @Generated
    public IntegerFeature getLevel() {
        return this.level;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setEnchantment(EnchantmentFeature enchantment) {
        this.enchantment = enchantment;
    }

    @Generated
    public void setLevel(IntegerFeature level) {
        this.level = level;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

