/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.usage.useperday.manager;

import com.ssomar.score.data.Database;
import com.ssomar.score.data.UsePerDayQuery;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UsagePerDayManager {
    private static UsagePerDayManager instance;
    private final Map<String, Map<String, Map<String, Integer>>> usagePerDayMap = UsePerDayQuery.loadUsePerDay(Database.getInstance().connect());

    public static UsagePerDayManager getInstance() {
        if (instance == null) {
            instance = new UsagePerDayManager();
        }
        return instance;
    }

    public void save() {
        UsePerDayQuery.purgeUserPerDay(Database.getInstance().connect());
        UsePerDayQuery.insertPlayerUserPerDay(Database.getInstance().connect(), this.usagePerDayMap);
    }

    public void insertUsage(String player, String itemid) {
        SimpleDateFormat formater = new SimpleDateFormat("dd-MM-yy");
        Date today = new Date();
        String date = formater.format(today);
        if (this.usagePerDayMap.containsKey(date)) {
            Map<String, Map<String, Integer>> dateMap = this.usagePerDayMap.get(date);
            if (dateMap.containsKey(player)) {
                Map<String, Integer> playerMap = dateMap.get(player);
                if (playerMap.containsKey(itemid)) {
                    playerMap.put(itemid, playerMap.get(itemid) + 1);
                } else {
                    playerMap.put(itemid, 1);
                }
            } else {
                HashMap<String, Integer> playerMap = new HashMap<String, Integer>();
                playerMap.put(itemid, 1);
                dateMap.put(player, playerMap);
            }
        } else {
            HashMap dateMap = new HashMap();
            HashMap<String, Integer> playerMap = new HashMap<String, Integer>();
            playerMap.put(itemid, 1);
            dateMap.put(player, playerMap);
        }
    }

    public int getCount(String player, String itemid) {
        Date today = new Date();
        SimpleDateFormat formater = new SimpleDateFormat("dd-MM-yy");
        String date = formater.format(today);
        int nb = 0;
        if (this.usagePerDayMap.containsKey(date) && this.usagePerDayMap.get(date).containsKey(player) && this.usagePerDayMap.get(date).get(player).containsKey(itemid)) {
            nb = this.usagePerDayMap.get(date).get(player).get(itemid);
        }
        return nb;
    }
}

