/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.MaterialWithGroups;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MaterialWithGroupsFeature
extends FeatureAbstract<Optional<String>, MaterialWithGroupsFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<String> value;
    private Optional<String> defaultValue;
    private boolean acceptAir;
    private boolean acceptItems;
    private boolean acceptBlocks;

    public MaterialWithGroupsFeature(FeatureParentInterface parent, Optional<String> defaultValue, FeatureSettingsInterface featureSettings, boolean acceptAir, boolean acceptItems, boolean acceptBlocks) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
        this.acceptAir = acceptAir;
        this.acceptItems = acceptItems;
        this.acceptBlocks = acceptBlocks;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        this.value = MaterialWithGroups.getMaterialWithGroups(colorStr);
        if (!this.value.isPresent()) {
            errors.add("&cERROR, Couldn't load the Material with groups value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Materials with groups available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html");
        } else if (this.isRequirePremium() && !isPremiumLoading) {
            errors.add("&cERROR, Couldn't load the Material with groups value of " + this.getName() + " from config, value: " + this.value + " &7&o" + this.getParent().getParentInfo() + " &6>> Because it's a premium feature !");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(s -> config.set(this.getName(), s));
    }

    @Override
    public Optional<String> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public MaterialWithGroupsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        String finalValue = ((Optional)value).orElse(this.getSortMaterials().get(0));
        this.updateMaterialWithGroups(finalValue, gui);
    }

    @Override
    public MaterialWithGroupsFeature clone(FeatureParentInterface newParent) {
        MaterialWithGroupsFeature clone = new MaterialWithGroupsFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isAcceptAir(), this.isAcceptItems(), this.isAcceptBlocks());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        String string = this.getMaterialWithGroups((GUI)manager.getCache().get(editor));
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        string = this.nextMaterialWithGroups(string);
        this.updateMaterialWithGroups(string, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        String string = this.getMaterialWithGroups((GUI)manager.getCache().get(editor));
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        string = this.prevMaterialWithGroups(string);
        this.updateMaterialWithGroups(string, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateMaterialWithGroups(this.nextMaterialWithGroups(this.getMaterialWithGroups((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateMaterialWithGroups(this.prevMaterialWithGroups(this.getMaterialWithGroups((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public String nextMaterialWithGroups(String material) {
        boolean next = false;
        for (String check : this.getSortMaterials()) {
            if (check.equals(material)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortMaterials().get(0);
    }

    public String prevMaterialWithGroups(String material) {
        int i = -1;
        int cpt = 0;
        for (String check : this.getSortMaterials()) {
            if (check.equals(material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortMaterials().get(this.getSortMaterials().size() - 1);
        }
        return this.getSortMaterials().get(cpt - 1);
    }

    public void updateMaterialWithGroups(String material, GUI gui) {
        this.value = Optional.of(material);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        item.setType(MaterialWithGroups.getMaterial(material));
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 3);
        boolean find = false;
        for (String check : this.getSortMaterials()) {
            if (material.equals(check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + material));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
        }
        for (String check : this.getSortMaterials()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public String getMaterialWithGroups(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return MaterialWithGroups.getMaterialWithGroups(str.split("\u27a4 ")[1]).get();
        }
        return null;
    }

    public List<String> getSortMaterials() {
        return MaterialWithGroups.getMaterialWithGroupsList(this.acceptAir, this.acceptItems, this.acceptBlocks);
    }

    @Generated
    public Optional<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isAcceptAir() {
        return this.acceptAir;
    }

    @Generated
    public boolean isAcceptItems() {
        return this.acceptItems;
    }

    @Generated
    public boolean isAcceptBlocks() {
        return this.acceptBlocks;
    }

    @Generated
    public void setValue(Optional<String> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<String> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setAcceptAir(boolean acceptAir) {
        this.acceptAir = acceptAir;
    }

    @Generated
    public void setAcceptItems(boolean acceptItems) {
        this.acceptItems = acceptItems;
    }

    @Generated
    public void setAcceptBlocks(boolean acceptBlocks) {
        this.acceptBlocks = acceptBlocks;
    }
}

